package com.rapid.j2ee.framework.smartdbimport.validator;

import com.rapid.j2ee.framework.core.utils.NumberUtils;
import com.rapid.j2ee.framework.core.utils.StringUtils;
import com.rapid.j2ee.framework.core.utils.TypeChecker;
import com.rapid.j2ee.framework.smartdbimport.configurer.ImportTableColumnConfigurable;
import com.rapid.j2ee.framework.smartdbimport.configurer.ImportTableColumnDataValidator;
import com.rapid.j2ee.framework.smartdbimport.error.SmartTableColumnDataValidationErrorReceiver;
import com.rapid.j2ee.framework.smartdbimport.support.SmartResourceImportResult.ErrorInformation;
import com.rapid.j2ee.framework.smartdbimport.support.SmartResourceImportResult.ErrorType;

public class SmartTableColumnDataTypeDecimalValidator extends
		AbstractSmartTableColumnDataTypeValidator {

	public static final String TABLE_COLUMN_DATA_INTEGER_DIGIT_LENGTH_KEY = "int-length";

	public static final String TABLE_COLUMN_DATA_FRACTION_DIGIT_LENGTH_KEY = "fraction-length";

	public boolean doValidate(
			int rowNumber,
			int columnNumber,
			String columnValue,
			Object javaBean,
			SmartTableColumnDataValidationErrorReceiver smartTableColumnDataTypeErrorReceiver,
			ImportTableColumnConfigurable importTableColumnConfigurable,
			ImportTableColumnDataValidator importTableColumnDataValidator) {

		String orignalColumnValue = columnValue;

		if (TypeChecker.isEmpty(columnValue)) {
			return true;
		}

		columnValue = StringUtils.remove(columnValue, ",");

		if (columnValue.startsWith("+") || columnValue.startsWith("-")) {
			columnValue = columnValue.substring(1);
		}

		if (!TypeChecker.isBlueNumber(columnValue)
				|| ".".equalsIgnoreCase(columnValue)
				|| "+".equalsIgnoreCase(columnValue)
				|| "-".equalsIgnoreCase(columnValue)) {
			this.addErrorInformation(
					ErrorType.DataFieldTypeIllegalDecimalError, rowNumber,
					columnNumber, orignalColumnValue,
					smartTableColumnDataTypeErrorReceiver,
					importTableColumnConfigurable,
					importTableColumnDataValidator);
			return false;
		}

		String integerPartValue = StringUtils.substringBefore(columnValue, ".");
		String fractionPartValue = StringUtils.substringAfter(columnValue, ".");

		if (TypeChecker.isEmpty(integerPartValue)) {
			integerPartValue = "0";
		}

		if (TypeChecker.isEmpty(fractionPartValue)) {
			fractionPartValue = "0";
		}

		if (!TypeChecker.isLong(integerPartValue)
				|| !TypeChecker.isLong(fractionPartValue)) {

			this.addErrorInformation(
					ErrorType.DataFieldTypeIllegalDecimalError, rowNumber,
					columnNumber, orignalColumnValue,
					smartTableColumnDataTypeErrorReceiver,
					importTableColumnConfigurable,
					importTableColumnDataValidator);

			return false;
		}

		if (String.valueOf(NumberUtils.parseLong(integerPartValue)).length() > this
				.getParameterPlusIntegerValue(importTableColumnDataValidator,
						TABLE_COLUMN_DATA_INTEGER_DIGIT_LENGTH_KEY)) {

			this.addErrorInformation(
					ErrorType.DataFieldTypeRestrictedDecimalError, rowNumber,
					columnNumber, orignalColumnValue,
					smartTableColumnDataTypeErrorReceiver,
					importTableColumnConfigurable,
					importTableColumnDataValidator);

			return false;

		}

		if (fractionPartValue.equalsIgnoreCase("0")) {
			return true;
		}

		if (fractionPartValue.length() > this
				.getFractionDigitLength(importTableColumnDataValidator)) {
			this.addErrorInformation(
					ErrorType.DataFieldTypeRestrictedDecimalError, rowNumber,
					columnNumber, orignalColumnValue,
					smartTableColumnDataTypeErrorReceiver,
					importTableColumnConfigurable,
					importTableColumnDataValidator);

			return false;
		}

		return true;
	}

	protected int getFractionDigitLength(
			ImportTableColumnDataValidator importTableColumnDataValidator) {
		return this.getParameterPlusIntegerValue(
				importTableColumnDataValidator,
				TABLE_COLUMN_DATA_FRACTION_DIGIT_LENGTH_KEY);
	}

	protected ErrorType reviseErrorType(ErrorType type) {
		return type;
	}

	protected void addErrorInformation(
			ErrorType errorType,
			int rowNumber,
			int columnNumber,
			String columnValue,
			SmartTableColumnDataValidationErrorReceiver smartTableColumnDataTypeErrorReceiver,
			ImportTableColumnConfigurable importTableColumnConfigurable,
			ImportTableColumnDataValidator importTableColumnDataValidator) {
		smartTableColumnDataTypeErrorReceiver
				.addTableColumnDataTypeError(
						rowNumber,
						columnNumber,
						columnValue,
						importTableColumnConfigurable,
						ErrorInformation
								.valueOf(
										importTableColumnDataValidator
												.getErrorMessageFormat(),
										reviseErrorType(errorType),

										String.valueOf(rowNumber),
										String.valueOf(columnNumber),
										importTableColumnConfigurable
												.getTableColumnName(),
										columnValue,
										getParameterValue(
												importTableColumnDataValidator,
												TABLE_COLUMN_DATA_INTEGER_DIGIT_LENGTH_KEY),
										String
												.valueOf(this
														.getFractionDigitLength(importTableColumnDataValidator))));
	}
}
