package com.rapid.j2ee.framework.smartdbimport.validator;

import com.rapid.j2ee.framework.core.utils.StringUtils;
import com.rapid.j2ee.framework.smartdbimport.configurer.ImportTableColumnConfigurable;
import com.rapid.j2ee.framework.smartdbimport.configurer.ImportTableColumnDataValidator;
import com.rapid.j2ee.framework.smartdbimport.converter.SmartTableColumnDataTypeConverterParametersHolder;
import com.rapid.j2ee.framework.smartdbimport.error.SmartTableColumnDataValidationErrorReceiver;
import com.rapid.j2ee.framework.smartdbimport.support.SmartResourceImportResult.ErrorInformation;
import com.rapid.j2ee.framework.smartdbimport.support.SmartResourceImportResult.ErrorType;

public class SmartTableColumnDataTypeLengthValidator extends
		AbstractSmartTableColumnDataTypeValidator {

	public static final String TABLE_COLUMN_DATA_MAX_LENGTH_KEY = "max-length";

	public static final String TABLE_COLUMN_DATA_PRESERVATION_LENGTH_KEY = "view-length";

	public static final String TABLE_COLUMN_DATA_OVER255_ASCII_CHAR_LENGTH_KEY = "over255-ascii-char-length";

	private static final double DEFAULT_OVER255_ASCII_CHAR_LENGTH = 2.5d;

	private static final int TABLE_COLUMN_DATA_PRESERVATION_LENGTH = 2900;

	private static final int TABLE_COLUMN_DATA_ERROR_MESSAGE_LENGTH = 50;

	public boolean doValidate(
			int rowNumber,
			int columnNumber,
			String columnValue,
			Object javaBean,
			SmartTableColumnDataValidationErrorReceiver smartTableColumnDataTypeErrorReceiver,
			ImportTableColumnConfigurable importTableColumnConfigurable,
			ImportTableColumnDataValidator importTableColumnDataValidator) {

		int maxAvailabelLength = getParameterPlusIntegerValue(
				importTableColumnDataValidator,
				TABLE_COLUMN_DATA_MAX_LENGTH_KEY);

		double over255AsciiCharLength = getParameterDoubleValue(
				importTableColumnDataValidator,
				TABLE_COLUMN_DATA_OVER255_ASCII_CHAR_LENGTH_KEY,
				DEFAULT_OVER255_ASCII_CHAR_LENGTH);

		int preservationValueLength = getParameterPlusIntegerValue(
				importTableColumnDataValidator,
				TABLE_COLUMN_DATA_PRESERVATION_LENGTH_KEY,
				TABLE_COLUMN_DATA_PRESERVATION_LENGTH);

		int errorMessageValueLength = getParameterPlusIntegerValue(
				importTableColumnDataValidator,
				TABLE_COLUMN_DATA_PRESERVATION_LENGTH_KEY,
				TABLE_COLUMN_DATA_ERROR_MESSAGE_LENGTH);

		if (StringUtils.getStringLengthWithSpecialDigitAtOver255Ascii(
				columnValue, over255AsciiCharLength) > maxAvailabelLength) {

			SmartTableColumnDataTypeConverterParametersHolder.getInstance()
					.setParameters(maxAvailabelLength, over255AsciiCharLength);

			smartTableColumnDataTypeErrorReceiver
					.addTableColumnDataTypeError(
							rowNumber,
							columnNumber,
							StringUtils.getStringContextWithinLength(
									columnValue, over255AsciiCharLength,
									preservationValueLength, "......"),
							importTableColumnConfigurable,
							ErrorInformation
									.valueOf(
											importTableColumnDataValidator
													.getErrorMessageFormat(),
											ErrorType.DataFieldTypeOverMaxLengthError,
											String.valueOf(rowNumber),
											String.valueOf(columnNumber),
											importTableColumnConfigurable
													.getTableColumnName(),
											StringUtils
													.getStringContextWithinLength(
															columnValue,
															over255AsciiCharLength,
															errorMessageValueLength,
															"......"),

											String.valueOf(maxAvailabelLength),

											String
													.valueOf(((int) (maxAvailabelLength / over255AsciiCharLength)))));

			return false;
		}

		return true;

	}
}
