package com.rapid.j2ee.framework.smartdbimport.validator;

import com.rapid.j2ee.framework.core.utils.TypeChecker;
import com.rapid.j2ee.framework.smartdbimport.configurer.ImportTableColumnConfigurable;
import com.rapid.j2ee.framework.smartdbimport.configurer.ImportTableColumnDataValidator;
import com.rapid.j2ee.framework.smartdbimport.error.SmartTableColumnDataValidationErrorReceiver;
import com.rapid.j2ee.framework.smartdbimport.support.SmartResourceImportResult.ErrorInformation;
import com.rapid.j2ee.framework.smartdbimport.support.SmartResourceImportResult.ErrorType;

public class SmartTableColumnDataTypeMandatoryValidator implements
		SmartTableColumnDataTypeValidator {

	public boolean validate(
			int rowNumber,
			int columnNumber,
			String columnValue,
			Object javaBean,
			SmartTableColumnDataValidationErrorReceiver smartTableColumnDataTypeErrorReceiver,
			ImportTableColumnConfigurable importTableColumnConfigurable,
			ImportTableColumnDataValidator importTableColumnDataValidator) {

		if (TypeChecker.isEmpty(columnValue)) {

			smartTableColumnDataTypeErrorReceiver
					.addTableColumnDataTypeError(rowNumber, columnNumber,
							columnValue, importTableColumnConfigurable,
							ErrorInformation.valueOf(
									importTableColumnDataValidator
											.getErrorMessageFormat(),
									ErrorType.DataFieldTypeMandatoryError,
									String.valueOf(rowNumber), String
											.valueOf(columnNumber),
									importTableColumnConfigurable
											.getTableColumnName()));

			return false;
		}

		return true;
	}

}
