package com.rapid.j2ee.framework.struts2.interceptor;

import java.util.Map;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.interceptor.AbstractInterceptor;
import com.opensymphony.xwork2.interceptor.NoParameters;

public abstract class AbstractHttpRequestParameterResolveInterceptor extends
		AbstractInterceptor {

	private static final long serialVersionUID = -3060731391639530600L;

	@Override
	public final String intercept(ActionInvocation invocation) throws Exception {

		Object action = invocation.getAction();

		if (!(action instanceof NoParameters)) {

			if (!before(invocation)) {
				return invocation.invoke();

			}

			ActionContext ac = invocation.getInvocationContext();

			Map<String, Object> parameters = ac.getParameters();

			for (Map.Entry<String, Object> entry : parameters.entrySet()) {

				if (entry.getValue() instanceof String[]) {

					String[] values = (String[]) entry.getValue();

					for (int i = 0, j = values.length; i < j; i++) {

						values[i] = this.resolveRequestParameter(invocation,
								entry.getKey(), values[i]);

					}

					parameters.put(entry.getKey(), values);

				}

			}

			after(invocation);

		}

		return invocation.invoke();
	}

	protected boolean before(ActionInvocation invocation) {
		return true;
	}

	protected void after(ActionInvocation invocation) {

	}

	protected abstract String resolveRequestParameter(
			ActionInvocation invocation, String name, String value);

	protected Log logger = LogFactory.getLog(this.getClass());

}
