package com.rapid.j2ee.framework.struts2.interceptor;

import com.opensymphony.xwork2.ActionInvocation;
import com.rapid.j2ee.framework.core.utils.SafeHtmlUtils;

/**
 * 拦截请求参数（主要是表单参数）将其中的不安全元素转义
 * 
 * @author Luke
 * 
 */
public class OwaspRequestParametersInterceptor extends
		AbstractHttpRequestParameterResolveInterceptor {

	@Override
	protected String resolveRequestParameter(ActionInvocation invocation,
			String name, String value) {

		return SafeHtmlUtils.getSafeHtml(value);
	}

	private static final long serialVersionUID = 1L;

}
