package com.rapid.j2ee.framework.struts2.interceptor;

import java.util.Enumeration;

import com.opensymphony.xwork2.ActionInvocation;
import com.rapid.j2ee.framework.core.utils.StringUtils;
import com.rapid.j2ee.framework.core.utils.TypeChecker;
import com.rapid.j2ee.framework.mvc.utils.ActionContextUtils;
import com.rapid.j2ee.framework.mvc.web.MvcBaseActionSupport;

public class RequestParameterLogInterceptor extends
		AbstractHttpRequestParameterResolveInterceptor {

	private static final long serialVersionUID = 1L;

	@Override
	protected boolean before(ActionInvocation actionInvocation) {

		if (actionInvocation.getAction() instanceof MvcBaseActionSupport) {
			traceRequestParameter = ((MvcBaseActionSupport) actionInvocation
					.getAction()).isStrutsDevModeOpen();

		}

		if (!TypeChecker.isEmpty(ActionContextUtils
				.getHttpParameter(Request_Parameter_Trace_Request_KeyName))) {
			traceRequestParameter = TypeChecker
					.isSpecialTrue(ActionContextUtils
							.getHttpParameter(Request_Parameter_Trace_Request_KeyName));
		}

		if (!traceRequestParameter) {
			return false;

		}

		this.traceRequestHeaders();

		logger.info("Request Parameters Log ["
				+ StringUtils.trimToEmpty(ActionContextUtils
						.getActionMethodName(), ActionContextUtils
						.getHttpParameter("method")) + "/"
				+ actionInvocation.getAction().getClass().getSimpleName()
				+ "]..............................");

		return true;

	}

	@Override
	protected String resolveRequestParameter(ActionInvocation invocation,
			String name, String value) {

		logger.info(name + "=[" + value + "]");

		return value;
	}

	private void traceRequestHeaders() {

		logger.info("Request Headers Log Start...........................");

		Enumeration<String> enums = ActionContextUtils.getHttpRequest()
				.getHeaderNames();

		for (String name = null; enums.hasMoreElements();) {
			name = enums.nextElement();

			System.out.println(name + "="
					+ ActionContextUtils.getHttpRequest().getHeader(name));
		}
		logger.info("Request Headers Log End...........................");
	}

	@Override
	protected void after(ActionInvocation invocation) {
		logger.info("Request Parameters Log End..............................");
	}

	private static final String Request_Parameter_Trace_Request_KeyName = "requestTraceStatus";

	private static boolean traceRequestParameter = false;

}
