package com.rapid.j2ee.framework.struts2.interceptor.resolver;

import java.util.List;

import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.ActionEventListener;
import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.ActionProxy;
import com.opensymphony.xwork2.Result;
import com.opensymphony.xwork2.interceptor.PreResultListener;
import com.opensymphony.xwork2.util.ValueStack;
import com.rapid.j2ee.framework.core.io.xml.XNode;
import com.rapid.j2ee.framework.core.io.xml.XPathParser;
import com.rapid.j2ee.framework.core.io.xml.XmlPaserJavaBean;
import com.rapid.j2ee.framework.core.io.xml.XmlPaserJavaBeanFilter;
import com.rapid.j2ee.framework.core.reflect.ConstructorUtils;
import com.rapid.j2ee.framework.core.reflect.InvokeUtils;
import com.rapid.j2ee.framework.core.spring.SpringApplicationContextHolder;
import com.rapid.j2ee.framework.core.utils.CollectionsUtil;
import com.rapid.j2ee.framework.core.utils.ResourceUtils;
import com.rapid.j2ee.framework.struts2.interceptor.resolver.configure.ParameterHandler;
import com.rapid.j2ee.framework.struts2.interceptor.resolver.configure.ParameterResolver;
import com.rapid.j2ee.framework.struts2.interceptor.resolver.configure.RequestParameter;
import com.rapid.j2ee.framework.struts2.interceptor.resolver.configure.RequestParameterValueResolver;
import com.rapid.j2ee.framework.struts2.interceptor.resolver.plugin.ParameterValueResolver;
import com.rapid.j2ee.framework.struts2.interceptor.resolver.test.TestAction;

public class RequestParameterValueResolverConfigureParser implements
		InitializingBean {

	public RequestParameterValueResolverConfigureParser() {

	}

	public String resolve(ActionInvocation invocation, String name, String value) {

		if (!requestParameterNameResolver.hasParameterResolvers()) {
			return value;
		}

		List<ParameterResolver> parameterResolvers = CollectionsUtil.find(
				requestParameterNameResolver.getPrameterResolvers(), "action",
				invocation.getAction().getClass().getSimpleName(), "*");

		for (ParameterResolver parameterResolver : parameterResolvers) {
			value = this.resolveByParameterResolver(parameterResolver, name,
					value);
		}

		return value;
	}

	private String resolveByParameterResolver(
			ParameterResolver parameterResolver, String name, String value) {

		List<RequestParameter> requestParameters = CollectionsUtil.find(
				parameterResolver.getRequestParameters(), "name", name, "*");

		for (RequestParameter requestParameter : requestParameters) {

			for (ParameterHandler parameterHandler : requestParameter
					.getParameterHandlers()) {

				value = parameterHandler.getParameterNameResolver().resolve(
						name, value);
			}

		}

		return value;

	}

	private void parse() throws Exception {

		XPathParser xPathParser = new XPathParser(ResourceUtils.getResource(
				this.requestParameterNameResolverConfigureLocation)
				.getInputStream(), this.encode);

		XmlPaserJavaBean<RequestParameterValueResolver> xmlPaserJavaBean = new XmlPaserJavaBean<RequestParameterValueResolver>(
				xPathParser, RequestParameterValueResolver.class);

		xmlPaserJavaBean
				.addXmlPaserJavaBeanFilter(new XmlPaserJavaBeanFilter<RequestParameterValueResolver>() {

					public Object resolve(
							RequestParameterValueResolver beanResolve,
							String nodeName, Object tagBean, XNode xNode,
							XPathParser xPathParser) {

						if (!(tagBean instanceof ParameterHandler)) {
							return tagBean;
						}

						ParameterHandler parameterHandler = (ParameterHandler) tagBean;

						if (nodeName.equalsIgnoreCase("handler")) {

							parameterHandler = beanResolve
									.findParameterHandlerByName(parameterHandler
											.getName());

							Assert.notNull(parameterHandler,
									"Please provide a existed parameter hander name:"
											+ parameterHandler.getName());


							return parameterHandler;

						}

						if (nodeName.equalsIgnoreCase("parameter-handler")) {

							if (parameterHandler.isSpringFactory()) {
								parameterHandler
										.setParameterNameResolver((ParameterValueResolver) SpringApplicationContextHolder.getBean(parameterHandler.getProcessor()));
							} else {
								parameterHandler
										.setParameterNameResolver((ParameterValueResolver) ConstructorUtils
												.newInstance(parameterHandler
														.getProcessor()));
							}

							setParameterNameResolverProperties(xNode,
									parameterHandler);

						}

						return tagBean;

					}

				});

		requestParameterNameResolver = xmlPaserJavaBean.resolve();

		System.out.println(requestParameterNameResolver.getPrameterResolvers());

	}

	private void setParameterNameResolverProperties(XNode xNode,
			ParameterHandler parameterHandler) {

		for (XNode propertyNode : xNode.evalNodes("property")) {

			InvokeUtils.setField(parameterHandler.getParameterNameResolver(),
					propertyNode.getStringAttribute("name"), propertyNode
							.getStringAttribute("value"));

		}

	}

	public void afterPropertiesSet() throws Exception {

		Assert
				.hasLength(requestParameterNameResolverConfigureLocation,
						"Please provide request Parameter Name Resolver Configure Location!");

		this.parse();
	}

	public void setRequestParameterNameResolverConfigureLocation(
			String requestParameterNameResolverConfigureLocation) {
		this.requestParameterNameResolverConfigureLocation = requestParameterNameResolverConfigureLocation;
	}

	public void setEncode(String encode) {
		this.encode = encode;
	}

	private String requestParameterNameResolverConfigureLocation;

	private String encode = "utf-8";

	private RequestParameterValueResolver requestParameterNameResolver;

	public static void main(String[] args) {

		RequestParameterValueResolverConfigureParser parser = new RequestParameterValueResolverConfigureParser();

		parser
				.setRequestParameterNameResolverConfigureLocation("classpath:HttpParameterNameResolverConfigure.xml");

		try {
			parser.afterPropertiesSet();
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

		ActionInvocation actionInvocation = new ActionInvocation() {

			public void addPreResultListener(PreResultListener arg0) {
				// TODO Auto-generated method stub

			}

			public Object getAction() {

				return new TestAction();
			}

			public ActionContext getInvocationContext() {
				// TODO Auto-generated method stub
				return null;
			}

			public ActionProxy getProxy() {
				// TODO Auto-generated method stub
				return null;
			}

			public Result getResult() throws Exception {
				// TODO Auto-generated method stub
				return null;
			}

			public String getResultCode() {
				// TODO Auto-generated method stub
				return null;
			}

			public ValueStack getStack() {
				// TODO Auto-generated method stub
				return null;
			}

			public void init(ActionProxy arg0) {
				// TODO Auto-generated method stub

			}

			public String invoke() throws Exception {
				// TODO Auto-generated method stub
				return null;
			}

			public String invokeActionOnly() throws Exception {
				// TODO Auto-generated method stub
				return null;
			}

			public boolean isExecuted() {
				// TODO Auto-generated method stub
				return false;
			}

			public void setActionEventListener(ActionEventListener arg0) {
				// TODO Auto-generated method stub

			}

			public void setResultCode(String arg0) {
				// TODO Auto-generated method stub

			}

		};

		System.out.println(parser.resolve(actionInvocation, "subFuncType",
				"请输入Abccc"));
		System.out.println(parser.resolve(actionInvocation, "subFuncType",
				"Abccc"));

	}

}
