package com.rapid.j2ee.framework.struts2.interceptor.resolver.configure;

import java.io.UnsupportedEncodingException;
import java.util.List;

import com.rapid.j2ee.framework.core.io.xml.XPathParser;
import com.rapid.j2ee.framework.core.io.xml.XPathTagBean;
import com.rapid.j2ee.framework.core.io.xml.XmlPaserJavaBean;
import com.rapid.j2ee.framework.core.utils.CollectionsUtil;
import com.rapid.j2ee.framework.core.utils.ObjectAnalyzer;
import com.rapid.j2ee.framework.core.utils.ObjectUtils;
import com.rapid.j2ee.framework.core.utils.TypeChecker;

public class RequestParameterValueResolver {

	@XPathTagBean(value = "parameter-resolvers/paramter-resolver")
	private List<ParameterResolver> prameterResolvers = ObjectUtils.EMPTY_LIST;

	@XPathTagBean(order = 1, value = "parameter-resolvers/parameter-handlers/parameter-handler")
	private List<ParameterHandler> parameterHandlers = ObjectUtils.EMPTY_LIST;

	public boolean hasParameterResolvers() {
		return !TypeChecker.isEmpty(this.prameterResolvers);
	}

	public List<ParameterHandler> getParameterHandlers() {
		return parameterHandlers;
	}

	public void setParameterHandlers(List<ParameterHandler> parameterHandlers) {
		this.parameterHandlers = parameterHandlers;
	}

	public List<ParameterResolver> getPrameterResolvers() {
		return prameterResolvers;
	}

	public void setPrameterResolvers(List<ParameterResolver> prameterResolvers) {
		this.prameterResolvers = prameterResolvers;
	}

	public ParameterHandler findParameterHandlerByName(String name) {
		return CollectionsUtil.findOne(this.parameterHandlers, "name", name);
	}

	public static void main(String[] args) throws UnsupportedEncodingException {

		XPathParser xPathParser = new XPathParser(
				RequestParameterValueResolver.class
						.getResourceAsStream("HttpParameterNameResolverConfigure.xml"),
				"utf-8");

		XmlPaserJavaBean xmlPaserJavaBean = new XmlPaserJavaBean(xPathParser,
				RequestParameterValueResolver.class);

		RequestParameterValueResolver resolver = (RequestParameterValueResolver) xmlPaserJavaBean
				.resolve();

		System.out.println(ObjectAnalyzer.toString(resolver));

	}

}
