package com.rapid.j2ee.framework.struts2.interceptor.resolver.plugin;

import com.rapid.j2ee.framework.core.utils.ObjectUtils;
import com.rapid.j2ee.framework.core.utils.StringUtils;

public class ParameterIngoreTipValueResolver implements ParameterValueResolver {

	private String[] startTipKeywords;

	public ParameterIngoreTipValueResolver() {
		startTipKeywords = ObjectUtils.EMPTY_STRING_ARRAYS;
	}

	public String resolve(String name, String value) {

		value = StringUtils.trimToEmpty(value);

		for (String startTipKeyword : startTipKeywords) {
			
			if (value.startsWith(startTipKeyword)) {
				
				System.out.println(startTipKeyword + " value " + value);
				
				return "";
			}
		}

		return value;
	}

	public void setStartTipKeywords(String[] startTipKeywords) {
		this.startTipKeywords = startTipKeywords;
	}

}
