package com.rapid.j2ee.framework.struts2.typeconverter;

import java.math.BigDecimal;
import java.util.Map;

import org.apache.struts2.util.StrutsTypeConverter;

import com.rapid.j2ee.framework.core.utils.NumberUtils;
import com.rapid.j2ee.framework.core.utils.TypeChecker;

public class BigDecimalTypeConverter extends StrutsTypeConverter {

	@Override
	public Object convertFromString(Map context, String[] values, Class toClass) {

		if (Number.class.isAssignableFrom(toClass)) {

			if (TypeChecker.isEmpty(values[0])) {
				return null;
			}

		}

		return NumberUtils.parseBigDecimal(values[0], "0");

	}

	@Override
	public String convertToString(Map context, Object value) {

		if (TypeChecker.isEmptyObject(value)) {
			return "";
		}

		return String.valueOf(value);
	}
}
