package com.rapid.j2ee.framework.struts2.typeconverter;

import java.util.Date;
import java.util.Map;

import org.apache.struts2.util.StrutsTypeConverter;

import com.rapid.j2ee.framework.core.utils.DateTimeUtils;
import com.rapid.j2ee.framework.core.utils.NumberUtils;
import com.rapid.j2ee.framework.core.utils.TypeChecker;
import com.rapid.j2ee.framework.core.utils.support.DateTimeFormat;

public class BooleanTypeConverter extends StrutsTypeConverter {

	@Override
	public Object convertFromString(Map context, String[] values, Class toClass) {

		return Boolean.valueOf( TypeChecker.isSpecialTrue(values[0]));
	}

	@Override
	public String convertToString(Map context, Object booleanValue) {

		if (booleanValue instanceof String) {
			return (String) booleanValue;
		}

		return String.valueOf(booleanValue);
	}

}
