package com.rapid.j2ee.framework.struts2.typeconverter;

import java.util.Date;
import java.util.Map;

import org.apache.struts2.util.StrutsTypeConverter;

import com.rapid.j2ee.framework.core.utils.DateTimeUtils;
import com.rapid.j2ee.framework.core.utils.TypeChecker;
import com.rapid.j2ee.framework.core.utils.support.DateTimeFormat;

public class DateTypeConverter extends StrutsTypeConverter {

	@Override
	public Object convertFromString(Map context, String[] values, Class toClass) {

		if (TypeChecker.isEmpty(values[0])) {
			return null;
		}

		return DateTimeUtils.convertWebToDate(values[0], DateTimeFormat
				.getDateTimeFormat(DateTimeFormat.YYYY_MM_DD.getFormat() + " "
						+ DateTimeUtils.getTimePartFormat(values[0])));
	}

	@Override
	public String convertToString(Map context, Object dateValue) {

		if (dateValue instanceof String) {
			return (String) dateValue;
		}

		return DateTimeUtils.convertDateToWeb((Date) dateValue,
				DateTimeFormat.YYYY_MM_DD_HH_MM_SS);
	}

}
