package com.rapid.j2ee.framework.unit;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;

import org.springframework.context.ApplicationContext;
import org.springframework.util.Assert;

import com.rapid.j2ee.framework.core.reflect.InvokeUtils;
import com.rapid.j2ee.framework.core.spring.SpringApplicationContextHolder;
import com.rapid.j2ee.framework.core.spring.SpringIbatisClassPathXmlApplicationContext;
import com.rapid.j2ee.framework.core.utils.ClassUtils;
import com.rapid.j2ee.framework.core.utils.ObjectUtils;

public abstract class AbstractSpringMainUnit {

	protected ApplicationContext applicationContext;

	public AbstractSpringMainUnit() {

		this.initApplicationContext();

		this.doAllUnitTests();
	}

	private void initApplicationContext() {

		Assert.isTrue(this.getClass().isAnnotationPresent(
				SpringApplicationContext.class),
				"Please provide @SpringApplicationContext on the top of "
						+ this.getClass().getSimpleName());

		SpringApplicationContext springApplicationContext = this.getClass()
				.getAnnotation(SpringApplicationContext.class);

		applicationContext = new SpringIbatisClassPathXmlApplicationContext(
				springApplicationContext.value());

		this.initAutowiredFieldVariables();
	}

	private void initAutowiredFieldVariables() {

		SpringApplicationContextHolder.inject(this);

	}

	private void doAllUnitTests() {

		invokeAllMethods(UnitTestBefore.class);

		invokeAllMethods(UnitTest.class);

		invokeAllMethods(UnitTestAfter.class);
	}

	private void invokeAllMethods(Class<? extends Annotation> annotationClass) {

		Method[] methods = ClassUtils.getAllMethodsAsClassByAnnotation(this
				.getClass(), annotationClass);

		for (Method method : methods) {
			try {
				InvokeUtils.invoke(this, method.getName(),
						ObjectUtils.EMPTY_CLASS_ARRAYS,
						ObjectUtils.EMPTY_OBJECT_ARRAYS);
			} catch (Exception e) {
				e.printStackTrace();
			}
		}

	}

}
