package org.apache.commons.fileupload;

import java.util.HashMap;
import java.util.Map;

import com.opensymphony.xwork2.ActionContext;
import com.rapid.j2ee.framework.core.utils.TypeChecker;

public class FileUploadThreadLocal {

	private static FileUploadThreadLocal INSTANCE = new FileUploadThreadLocal();

	private FileUploadThreadLocal() {

	}

	public static FileUploadThreadLocal getInstance() {
		return INSTANCE;
	}

	public void setParameter(String name, String value) {

		getRequestLocalMap().put(name, value);
	}

	public String getParameter(String name) {

		return getRequestLocalMap().get(name);
	}

	public void setMethod(String name) {

		if (!TypeChecker.isNull(getMethod())) {
			return;
		}

		ActionContext.getContext().put("FileUploadThreadLocal.Method", name);
	}

	public String getMethod() {
		return (String) ActionContext.getContext().get(
				"FileUploadThreadLocal.Method");
	}

	private Map<String, String> getRequestLocalMap() {

		Map<String, String> localMap = (Map<String, String>) ActionContext
				.getContext().get("FileUploadThreadLocal.RequestLocalMap");

		if (TypeChecker.isNull(localMap)) {
			localMap = new HashMap<String, String>();

			ActionContext.getContext().put(
					"FileUploadThreadLocal.RequestLocalMap", localMap);
		}

		return localMap;
	}

}
