package com.john.daydaymusic;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

import com.rapid.j2ee.framework.core.charset.CharsetType;
import com.rapid.j2ee.framework.core.charset.Charsets;
import com.rapid.j2ee.framework.core.io.file.FileReader;
import com.rapid.j2ee.framework.core.io.file.FileWriter;
import com.rapid.j2ee.framework.core.io.http.HttpGetClient;
import com.rapid.j2ee.framework.core.io.http.HttpPostClient;
import com.rapid.j2ee.framework.core.io.json.JsonUtils;
import com.rapid.j2ee.framework.core.utils.FileUtils;
import com.rapid.j2ee.framework.core.utils.StringUtils;
import com.rapid.j2ee.framework.core.utils.TypeChecker;

public class DayDayKissMusicDownload {

	public DayDayKissMusicDownload(String path) {
		this.path = path;
		FileUtils.makeDir(path);
	}

	public List<Singer> getSingers(int channel) {

		HttpGetClient get = new HttpGetClient(
				"http://www.dongting.com/ajax/v1.ard.tj.itlily.com/ttpod?id="+49+"&page=1&size=10000");

		String musics = get.executeContent();

		JSONArray jsonArray = JSONObject.fromObject(musics)
				.getJSONArray("data");

		return JSONArray.toList(jsonArray, Singer.class);

	}

	public boolean store(String keyword, int page) {

		HttpPostClient post = new HttpPostClient(
				"http://so.ard.iyyin.com/s/song_with_out");

		post.setHeader("Host", "so.ard.iyyin.com");
		post.setHeader(
				"User-Agent",
				"Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/33.0.1750.146 Safari/537.36");
		post.setHeader("Accept", "*/*");
		post.setHeader("Referer", "http://www.dongting.com/");

		post.addParameter("q", keyword);
		post.addParameter("page", String.valueOf(page));
		post.addParameter("size", String.valueOf(200));
		post.addParameter("callback", "jsonp_search");

		String musics = post.executeContent();

		musics = StringUtils.remove(musics, "jsonp_search(");

		musics = StringUtils.substringBeforeLast(musics, ")");

		Map<String, Class> configs = new HashMap<String, Class>(1);
		configs.put("audition_list", SongAudition.class);

		JSONArray jsonArray = JSONObject.fromObject(musics)
				.getJSONArray("data");

		if (jsonArray == null) {
			return false;
		}

		List<SongItem> songItems = JSONArray.toList(jsonArray, SongItem.class,
				configs);

		if (TypeChecker.isEmpty(songItems)) {
			return false;
		}

		File file = new File(FileUtils.getFile(this.path, keyword), "song_"
				+ page + ".json");

		System.out.println(file.getAbsolutePath());

		FileUtils.makeDir(file.getAbsolutePath());

		FileWriter fw = new FileWriter(file,
				Charsets.getCharsetInstance(CharsetType.UTF_8));

		fw.writeln(JsonUtils.formatJsonText(songItems));

		fw.close();

		return true;

	}

	public static void download() {
		
		int channel = 53;
		
		
		DayDayKissMusicDownload dayDayKissMusicDownload = new DayDayKissMusicDownload(
				"weixin/daydaymusic/singername/" +channel);
	
		
		for (Singer singer : dayDayKissMusicDownload.getSingers(channel)) {

			if (dayDayKissMusicDownload.isExists(singer.getSinger_name())) {
				continue;
			}

			int page = 0;

			try {

				while (dayDayKissMusicDownload.store(singer.getSinger_name(),
						page++)) {

				}
			} catch (Exception e) {

				page--;

				try {
					while (dayDayKissMusicDownload.store(
							singer.getSinger_name(), page++)) {

					}
				} catch (Exception e2) {

					File log = new File("weixin/daydaymusic/singername/"+channel+"/log",
							singer.getSinger_name() + ".txt");
					FileUtils.makeDir(log.getAbsolutePath());
					FileWriter error = new FileWriter(log,
							Charsets.getCharsetInstance(CharsetType.UTF_8),
							true);

					error.write("error! ==" + singer.getSinger_name());

					error.close();

					System.out.println("error! ==" + singer.getSinger_name());
					e.printStackTrace();
				}

			}
		}

	}

	public static void main(String[] args) {
		
		download();

	}

	private boolean isExists(String name) {

		for (String file : new File(this.path).list()) {
			if (file.contains(name)) {
				return true;
			}
		}
		return false;
	}

	private String path;
}