/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.antx.config.cli;

import com.alibaba.antx.config.ConfigRuntime;
import com.alibaba.antx.config.ConfigRuntimeImpl;
import com.alibaba.antx.config.cli.CLIException;
import com.alibaba.antx.config.cli.CLIManager;
import com.alibaba.antx.util.Profiler;
import com.alibaba.antx.util.StringUtil;
import com.alibaba.antx.util.cli.CommandLine;
import com.alibaba.citrus.logconfig.LogConfigurator;
import java.text.MessageFormat;

public class Main {
    private static CommandLine cli;
    private static ConfigRuntime runtime;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] args) {
        int returnCode;
        block4: {
            Profiler.start("Starting antxconfig");
            Main.initLogging(false, null);
            returnCode = 0;
            try {
                try {
                    returnCode = Main.run(args);
                }
                catch (CLIException e) {
                    System.err.println(e.getMessage());
                    System.exit(returnCode);
                    Object var4_3 = null;
                    Profiler.release();
                    break block4;
                }
                Object var4_2 = null;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                Profiler.release();
                throw throwable;
            }
            Profiler.release();
        }
        runtime.info("");
        runtime.info(Main.getDuration("\u603b\u8017\u8d39\u65f6\u95f4\uff1a{0,choice,0#|.1#{0,number,integer}\u5206}{1,choice,0#|.1#{1,number,integer}\u79d2}{2,number,integer}\u6beb\u79d2", Profiler.getEntry().getDuration()));
        runtime.info("");
        System.exit(returnCode);
    }

    private static String getDuration(String message, long duration) {
        long ms = duration % 1000L;
        long secs = duration / 1000L % 60L;
        long min = duration / 1000L / 60L;
        return MessageFormat.format(message, new Long(min), new Long(secs), new Long(ms));
    }

    private static void initLogging(boolean verbose, String charset) {
        LogConfigurator.getConfigurator().configureDefault(verbose, charset);
    }

    private static int run(String[] args) {
        CLIManager manager = new CLIManager();
        if (args.length == 0) {
            args = new String[]{"-h"};
        }
        cli = manager.parse(args);
        String charset = cli.getOptionValue("c");
        ConfigRuntimeImpl runtimeImpl = new ConfigRuntimeImpl(System.in, System.out, System.err, charset);
        runtime = runtimeImpl;
        if (cli.hasOption("h")) {
            manager.help(runtimeImpl.getOut());
            return 0;
        }
        if (cli.hasOption("g")) {
            runtimeImpl.setGuiMode();
        }
        if (cli.hasOption("t")) {
            runtimeImpl.setTextMode();
        }
        if (cli.hasOption("I")) {
            runtimeImpl.setInteractiveMode("off");
        } else if (cli.hasOption("i")) {
            String mode = cli.getOptionValue("i");
            if (StringUtil.isBlank(mode)) {
                runtimeImpl.setInteractiveMode("on");
            } else {
                runtimeImpl.setInteractiveMode(mode);
            }
        }
        runtimeImpl.setDescriptorPatterns(cli.getOptionValue("d"), cli.getOptionValue("D"));
        runtimeImpl.setPackagePatterns(cli.getOptionValue("p"), cli.getOptionValue("P"));
        runtimeImpl.setType(cli.getOptionValue("T"));
        runtimeImpl.setDests(cli.getArgs());
        String[] outputs = null;
        if (cli.hasOption("o")) {
            String outputFileNames = cli.getOptionValue("o");
            if (outputFileNames != null) {
                outputs = outputFileNames.split("[,\\s]+");
            }
            runtimeImpl.setOutputs(outputs);
        }
        if (cli.hasOption("u")) {
            runtimeImpl.setUserPropertiesFile(cli.getOptionValue("u"), charset);
        }
        if (cli.hasOption("s") || cli.hasOption("n")) {
            String[] sharedPropertiesFiles = StringUtil.split(cli.getOptionValue("s"));
            String sharedPropertiesName = cli.getOptionValue("n");
            runtimeImpl.setSharedPropertiesFiles(sharedPropertiesFiles, sharedPropertiesName, charset);
        }
        if (cli.hasOption("v")) {
            runtimeImpl.setVerbose();
            Main.initLogging(true, charset);
        } else {
            Main.initLogging(false, charset);
        }
        try {
            runtimeImpl.start();
        }
        catch (Exception e) {
            runtimeImpl.error(e);
        }
        return 0;
    }
}

