/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.antx.config.descriptor.validator;

import com.alibaba.antx.config.descriptor.ConfigValidator;
import com.alibaba.antx.util.StringUtil;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HostExistValidator
extends ConfigValidator {
    private static final Logger log = LoggerFactory.getLogger(HostExistValidator.class);
    private String hostname;

    public Logger getLogger() {
        return log;
    }

    public boolean validate(String value) {
        if (value == null) {
            return true;
        }
        if (StringUtil.isEmpty(value = value.trim())) {
            return true;
        }
        this.getLogger().info("Validating host name or IP address: " + value);
        this.hostname = value;
        try {
            InetAddress.getByName(this.hostname);
        }
        catch (UnknownHostException e) {
            return false;
        }
        return true;
    }

    protected String getDefaultMessage() {
        return "\u975e\u6cd5\u7684\u57df\u540d\u6216IP\uff1a" + this.hostname;
    }
}

