/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.antx.config.descriptor.validator;

import com.alibaba.antx.config.descriptor.ConfigValidator;
import com.alibaba.antx.util.StringUtil;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UrlValidator
extends ConfigValidator {
    private static final Logger log = LoggerFactory.getLogger(UrlValidator.class);
    private boolean checkHostExist = true;
    private String[] protocols;
    private boolean endsWithSlash = true;
    private String message;

    public Logger getLogger() {
        return log;
    }

    public void setCheckHostExist(boolean checkHostExist) {
        this.checkHostExist = checkHostExist;
    }

    public void setProtocols(String protocols) {
        this.protocols = StringUtil.split(protocols);
    }

    public void setEndsWithSlash(boolean endsWithSlash) {
        this.endsWithSlash = endsWithSlash;
    }

    public boolean validate(String value) {
        URL url;
        if (value == null) {
            return true;
        }
        if (StringUtil.isEmpty(value = value.trim())) {
            return true;
        }
        this.getLogger().info("Checking URL validility: " + value);
        this.message = "\u975e\u6cd5\u7684URL\uff1a" + value;
        try {
            url = new URL(value);
            if (StringUtil.isBlank(url.getHost())) {
                return false;
            }
        }
        catch (MalformedURLException e) {
            return false;
        }
        if (!this.validateProtocols(url.getProtocol())) {
            this.message = this.getProtocolMessage();
            return false;
        }
        if (this.checkHostExist) {
            this.getLogger().info("Validating host name or IP address: " + url.getHost());
            try {
                InetAddress.getByName(url.getHost());
            }
            catch (UnknownHostException e) {
                this.message = "\u975e\u6cd5\u7684\u57df\u540d\u6216IP\uff1a" + url.getHost();
                return false;
            }
        }
        if (this.endsWithSlash && !value.endsWith("/")) {
            this.message = "URL\u8bf7\u4ee5/\u7ed3\u5c3e";
            return false;
        }
        return true;
    }

    private boolean validateProtocols(String protocol) {
        if (protocol == null) {
            return false;
        }
        if (StringUtil.isEmpty(protocol = protocol.trim())) {
            return false;
        }
        if (this.protocols == null || this.protocols.length == 0) {
            return true;
        }
        if (this.getLogger().isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("Validating protocol with choice[");
            for (int i = 0; i < this.protocols.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(this.protocols[i]);
            }
            buffer.append("]: ").append(protocol);
            this.getLogger().debug(buffer.toString());
        }
        for (String protocol2 : this.protocols) {
            if (!protocol.equals(protocol2)) continue;
            return true;
        }
        return false;
    }

    protected String getDefaultMessage() {
        return this.message;
    }

    protected String getProtocolMessage() {
        StringBuffer buffer = new StringBuffer("\u60a8\u5fc5\u987b\u5728\u4e0b\u5217\u503c\u4e2d\u9009\u62e9\u534f\u8bae\uff1a");
        for (int i = 0; i < this.protocols.length; ++i) {
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append(this.protocols[i]);
        }
        return buffer.toString();
    }
}

