/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.antx.config.generator;

import com.alibaba.antx.config.ConfigException;
import com.alibaba.antx.config.generator.expr.CompositeExpression;
import com.alibaba.antx.config.generator.expr.Expression;
import com.alibaba.antx.config.generator.expr.ExpressionContext;
import com.alibaba.antx.config.generator.expr.ReferenceExpression;
import com.alibaba.antx.util.StringUtil;
import com.alibaba.antx.util.collection.ExtendedProperties;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;

public abstract class PropertiesLoader {
    public static Map loadPropertiesFile(InputStream istream, String propsCharset, String url) {
        return PropertiesLoader.loadPropertiesFile(istream, propsCharset, url, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Map loadPropertiesFile(InputStream istream, String propsCharset, String url, boolean closeOnExit) {
        ExtendedProperties props = new ExtendedProperties();
        try {
            try {
                props.load(istream, propsCharset, url);
            }
            catch (IOException e) {
                throw new ConfigException(e);
            }
            Object var7_5 = null;
            if (istream == null) return props;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            if (istream == null) throw throwable;
            try {
                istream.close();
                throw throwable;
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException e) {}
        istream.close();
        return props;
    }

    public static Map loadPropertiesFile(File propsFile, String propsCharset) {
        ExtendedProperties props = new ExtendedProperties();
        if (propsFile.exists()) {
            try {
                props.load(propsFile.toURI().toURL(), propsCharset);
            }
            catch (IOException e) {
                throw new ConfigException(e);
            }
        }
        return props;
    }

    public static void mergeProperties(Map dest, Map src) {
        for (Map.Entry entry : src.entrySet()) {
            Expression expr;
            String name = (String)entry.getKey();
            Object value = entry.getValue();
            if (value instanceof String && (expr = CompositeExpression.parse((String)value)) != null) {
                value = expr;
            }
            dest.put(name, value);
            dest.put(StringUtil.getValidIdentifier(name), value);
        }
    }

    public static Object evaluate(String name, final Map props) {
        return new ReferenceExpression(name).evaluate(new ExpressionContext(){

            public Object get(String key) {
                return props.get(key);
            }

            public void put(String key, Object value) {
                props.put(key, value);
            }
        });
    }
}

