/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.antx.config.props;

import com.alibaba.antx.config.generator.PropertiesLoader;
import com.alibaba.antx.config.props.PropertiesResource;
import com.alibaba.antx.config.resource.Resource;
import com.alibaba.antx.config.resource.ResourceManager;
import com.alibaba.antx.config.resource.ResourceURI;
import java.io.File;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class PropertiesFile
extends PropertiesResource {
    protected Set keys;
    protected Map props;

    protected PropertiesFile(ResourceManager manager) {
        super(manager);
    }

    public PropertiesFile(ResourceManager manager, String file) {
        super(manager);
        this.setURI(ResourceURI.guessURI(file));
    }

    public PropertiesFile(ResourceManager manager, File file) {
        super(manager);
        this.setURI(file);
    }

    public PropertiesFile(ResourceManager manager, URI uri) {
        super(manager);
        this.setURI(uri);
    }

    public PropertiesFile(ResourceManager manager, Resource res) {
        super(manager);
        this.setResource(res);
        this.setURI(res.getURI().getURI());
    }

    public Set getKeys() {
        this.load();
        return this.keys;
    }

    public Map getProperties() {
        this.load();
        return this.props;
    }

    protected void onLoad() {
        Map propsFromFile = PropertiesLoader.loadPropertiesFile(this.getResource().getInputStream(), this.getCharset(), this.getURI().toString());
        this.keys = new TreeSet(propsFromFile.keySet());
        this.props = new HashMap();
        PropertiesLoader.mergeProperties(this.props, propsFromFile);
    }

    protected void onError() {
        this.keys = new TreeSet();
        this.props = new HashMap();
    }
}

