/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.antx.config.props;

import com.alibaba.antx.config.ConfigException;
import com.alibaba.antx.config.generator.PropertiesLoader;
import com.alibaba.antx.config.generator.expr.Expression;
import com.alibaba.antx.config.props.PropertiesFile;
import com.alibaba.antx.config.props.PropertiesFileSet;
import com.alibaba.antx.config.props.PropertiesResource;
import com.alibaba.antx.config.props.SystemProperties;
import com.alibaba.antx.config.resource.ResourceManager;
import com.alibaba.antx.config.resource.ResourceURI;
import com.alibaba.antx.util.StringUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.PrintWriter;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.MatchResult;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesSet {
    private static final Logger log = LoggerFactory.getLogger(PropertiesSet.class);
    private final ResourceManager manager = new ResourceManager();
    private final SystemProperties systemProps = new SystemProperties();
    private boolean inited;
    private PropertiesResource[] sharedPropertiesFiles;
    private PropertiesFile[] sharedPropertiesFilesExpanded;
    private PropertiesFile userPropertiesFile;
    private Map namedPropertiesFiles;
    private String sharedName;
    private Map mergedProps;
    private Set mergedKeys;
    private static final Pattern ANTX_PROPERTIES_PATTERN;

    public PropertiesSet() {
        this(null, null);
    }

    public PropertiesSet(BufferedReader in, PrintWriter out) {
        this.manager.setIn(in);
        this.manager.setOut(out);
    }

    public SystemProperties getSystemProperties() {
        return this.systemProps;
    }

    public PropertiesFile getUserPropertiesFile() {
        return this.userPropertiesFile;
    }

    public void setUserPropertiesFile(String userPropertiesFile) {
        this.userPropertiesFile = new PropertiesFile(this.manager, userPropertiesFile);
    }

    public PropertiesResource[] getSharedPropertiesFiles() {
        return this.sharedPropertiesFiles;
    }

    public void setSharedPropertiesFiles(String[] sharedPropertiesFiles) {
        if (sharedPropertiesFiles == null) {
            this.sharedPropertiesFiles = new PropertiesFile[0];
            return;
        }
        PropertiesResource[] files = new PropertiesResource[sharedPropertiesFiles.length];
        for (int i = 0; i < sharedPropertiesFiles.length; ++i) {
            String sharedPropertiesFile = sharedPropertiesFiles[i];
            URI uri = ResourceURI.guessURI(sharedPropertiesFile);
            files[i] = new ResourceURI(uri).guessDirectory() ? new PropertiesFileSet(this.manager, uri) : new PropertiesFile(this.manager, uri);
        }
        this.sharedPropertiesFiles = files;
    }

    public String getSharedPropertiesFilesName() {
        return this.sharedName;
    }

    public void setSharedPropertiesFilesName(String sharedName) {
        this.sharedName = StringUtil.isEmpty(sharedName) ? null : sharedName;
    }

    public Map getMergedProperties() {
        this.init();
        return this.mergedProps;
    }

    public Set getMergedKeys() {
        this.init();
        return this.mergedKeys;
    }

    public PropertiesFile[] getSharedPropertiesFilesExpanded() {
        return this.sharedPropertiesFilesExpanded;
    }

    public void init() {
        ArrayList<String> fileList;
        if (this.inited) {
            return;
        }
        this.inited = true;
        if (this.userPropertiesFile == null) {
            File defaultPropertiesFile = new File("antx.properties").getAbsoluteFile();
            if (!defaultPropertiesFile.exists() || !defaultPropertiesFile.isFile()) {
                defaultPropertiesFile = new File(System.getProperty("user.home"), "antx.properties");
            }
            this.userPropertiesFile = new PropertiesFile(this.manager, defaultPropertiesFile.getAbsoluteFile());
        }
        this.userPropertiesFile.setAllowNonExistence(true);
        HashMap props = new HashMap();
        PropertiesLoader.mergeProperties(props, this.systemProps.getProperties());
        PropertiesLoader.mergeProperties(props, this.userPropertiesFile.getProperties());
        this.namedPropertiesFiles = this.getNamedSharedPropertiesFiles(props);
        if (this.sharedName == null) {
            if (this.sharedPropertiesFiles != null && this.sharedPropertiesFiles.length > 0) {
                this.sharedName = "default";
            } else {
                Object value = props.get("antx.properties");
                if (value instanceof Expression) {
                    value = ((Expression)value).evaluate(null);
                }
                this.sharedName = (String)value;
                if (StringUtil.isEmpty(this.sharedName)) {
                    this.sharedName = "default";
                }
            }
        }
        if (this.sharedPropertiesFiles != null && this.sharedPropertiesFiles.length > 0) {
            fileList = new ArrayList<String>(this.sharedPropertiesFiles.length);
            for (PropertiesResource resource : this.sharedPropertiesFiles) {
                fileList.add(resource.getURI().toString());
            }
            this.namedPropertiesFiles.put(this.sharedName, fileList);
        } else {
            fileList = (ArrayList<String>)this.namedPropertiesFiles.get(this.sharedName);
            String[] files = null;
            if (fileList != null) {
                files = fileList.toArray(new String[fileList.size()]);
            }
            this.setSharedPropertiesFiles(files);
        }
        this.loadUserProperties(false);
    }

    public boolean isShared(String name) {
        for (int i = this.sharedPropertiesFilesExpanded.length - 1; i >= 0; --i) {
            PropertiesFile sharedFile = this.sharedPropertiesFilesExpanded[i];
            if (!sharedFile.getProperties().containsKey(name)) continue;
            return true;
        }
        return false;
    }

    public Map getModifiedProperties() {
        HashMap<String, String> modifiedProperties = new HashMap<String, String>();
        for (String string : this.getMergedKeys()) {
            String value = this.toString(this.getMergedProperties().get(string));
            Perl5Matcher matcher = new Perl5Matcher();
            if (value == null || matcher.matches(string, ANTX_PROPERTIES_PATTERN) || "antx.properties".equals(string)) continue;
            String defaultValue = null;
            PropertiesFile[] files = this.getSharedPropertiesFilesExpanded();
            for (int j = files.length - 1; j >= 0; --j) {
                if (!files[j].getProperties().containsKey(string)) continue;
                defaultValue = this.toString(files[j].getProperties().get(string));
                break;
            }
            if (defaultValue == null && this.getSystemProperties().getProperties().containsKey(string)) {
                defaultValue = this.toString(this.getSystemProperties().getProperties().get(string));
            }
            if (defaultValue != null && defaultValue.equals(value)) continue;
            modifiedProperties.put(string, value);
        }
        for (Map.Entry entry : this.namedPropertiesFiles.entrySet()) {
            String name = (String)entry.getKey();
            List fileList = (List)entry.getValue();
            int index = 1;
            Iterator j = fileList.iterator();
            while (j.hasNext()) {
                String file = (String)j.next();
                String key = "antx.properties." + name;
                if (index > 1 || j.hasNext()) {
                    key = key + "." + index;
                }
                modifiedProperties.put(key, file);
                ++index;
            }
        }
        if (!"default".equals(this.sharedName)) {
            modifiedProperties.put("antx.properties", this.sharedName);
        }
        return modifiedProperties;
    }

    private String toString(Object value) {
        if (value == null || value instanceof String) {
            return (String)value;
        }
        if (value instanceof Expression) {
            return ((Expression)value).getExpressionText();
        }
        return String.valueOf(value);
    }

    public void reloadUserProperties() {
        this.loadUserProperties(true);
    }

    private void loadUserProperties(boolean reload) {
        this.mergedProps = new HashMap();
        this.mergedKeys = new TreeSet();
        this.mergedKeys.addAll(this.getSystemProperties().getKeys());
        PropertiesLoader.mergeProperties(this.mergedProps, this.getSystemProperties().getProperties());
        LinkedList expandedFiles = new LinkedList();
        for (int i = 0; i < this.getSharedPropertiesFiles().length; ++i) {
            this.loadResource(this.getSharedPropertiesFiles()[i], this.mergedProps, this.mergedKeys, expandedFiles);
        }
        this.sharedPropertiesFilesExpanded = expandedFiles.toArray(new PropertiesFile[expandedFiles.size()]);
        if (reload) {
            this.getUserPropertiesFile().reload();
        }
        this.mergedKeys.addAll(this.getUserPropertiesFile().getKeys());
        PropertiesLoader.mergeProperties(this.mergedProps, this.getUserPropertiesFile().getProperties());
        this.checkOverlap(reload);
    }

    private void checkOverlap(boolean reload) {
        Iterator i = this.getMergedKeys().iterator();
        while (i.hasNext()) {
            boolean overlapByUserProperties;
            Perl5Matcher matcher = new Perl5Matcher();
            String key = (String)i.next();
            if (matcher.matches(key, ANTX_PROPERTIES_PATTERN) || "antx.properties".equals(key)) continue;
            PropertiesFile[] files = this.getSharedPropertiesFilesExpanded();
            ArrayList<PropertiesFile> definedInFiles = new ArrayList<PropertiesFile>(files.length + 1);
            if (this.userPropertiesFile.getProperties().containsKey(key)) {
                definedInFiles.add(this.userPropertiesFile);
            }
            for (int j = files.length - 1; j >= 0; --j) {
                if (!files[j].getProperties().containsKey(key)) continue;
                definedInFiles.add(files[j]);
            }
            if (definedInFiles.size() <= 1) continue;
            StringBuffer message = new StringBuffer();
            boolean bl = overlapByUserProperties = definedInFiles.get(0) == this.userPropertiesFile;
            if (reload && !overlapByUserProperties) continue;
            message.append("\u8986\u76d6\u8b66\u544a\uff1a ");
            if (overlapByUserProperties) {
                message.append("\u7528\u6237properties\u6587\u4ef6\u4e2d\u7684\u503c\u201c").append(key).append("\u201d\u8986\u76d6\u4e86").append("\u5171\u4eabproperties\u6587\u4ef6\u4e2d\u7684\u503c\uff1a\n");
            } else {
                message.append("\u201c").append(key).append("\u201d\u51fa\u73b0\u5728").append(definedInFiles.size()).append("\u4e2a\u5171\u4eabproperties\u6587\u4ef6\u4e2d\uff08\u6700\u7ec8\u503c\u5c06\u4ee5\u7b2c\u4e00\u4e2a\u4e3a\u51c6\uff09\uff1a\n");
            }
            for (PropertiesFile f : definedInFiles) {
                message.append("  - ").append(f.getURI());
                message.append(", value = ").append(this.toString(f.getProperties().get(key))).append("\n");
            }
            log.warn(message.toString());
        }
    }

    private Map getNamedSharedPropertiesFiles(Map props) {
        TreeMap names = new TreeMap();
        Iterator<Object> i = props.keySet().iterator();
        while (i.hasNext()) {
            Object value;
            int index;
            Perl5Matcher matcher = new Perl5Matcher();
            String string = (String)i.next();
            if (!matcher.matches(string, ANTX_PROPERTIES_PATTERN)) continue;
            MatchResult result = matcher.getMatch();
            String name = result.group(1);
            try {
                index = Integer.parseInt(result.group(3));
            }
            catch (NumberFormatException e) {
                index = 0;
            }
            if (!names.containsKey(name)) {
                names.put(name, new TreeMap());
            }
            if ((value = props.get(string)) instanceof Expression) {
                value = ((Expression)value).evaluate(null);
            }
            ((Map)names.get(name)).put(new Integer(index), value);
        }
        for (Map.Entry entry : names.entrySet()) {
            ArrayList files = new ArrayList(((Map)entry.getValue()).values());
            entry.setValue(files);
        }
        return names;
    }

    private void loadResource(PropertiesResource resource, Map mergedProperties, Set mergedKeys, List expandedFiles) {
        if (resource instanceof PropertiesFile) {
            PropertiesFile file = (PropertiesFile)resource;
            expandedFiles.add(file);
            mergedKeys.addAll(file.getKeys());
            PropertiesLoader.mergeProperties(mergedProperties, file.getProperties());
        } else if (resource instanceof PropertiesFileSet) {
            PropertiesFileSet files = (PropertiesFileSet)resource;
            for (PropertiesResource pr : files.getPropertiesFiles()) {
                this.loadResource(pr, mergedProperties, mergedKeys, expandedFiles);
            }
        } else {
            throw new IllegalArgumentException("unknown resource type: " + resource.getClass().getName());
        }
    }

    static {
        try {
            ANTX_PROPERTIES_PATTERN = new Perl5Compiler().compile("antx\\.properties\\.(\\w+)(\\.(\\d+))?", 32768);
        }
        catch (MalformedPatternException e) {
            throw new ConfigException(e);
        }
    }
}

