/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.antx.config.resource;

import com.alibaba.antx.config.ConfigException;
import com.alibaba.antx.config.resource.AuthenticationHandler;
import com.alibaba.antx.config.resource.ResourceManager;
import com.alibaba.antx.config.resource.util.ResourceUtil;
import com.alibaba.antx.util.PasswordField;
import com.alibaba.antx.util.StringUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.Properties;
import org.apache.commons.codec.binary.Base64;

public class DefaultAuthenticationHandler
implements AuthenticationHandler {
    private final ResourceManager resourceManager;
    private final File passwordFile;

    public DefaultAuthenticationHandler(ResourceManager resourceManager) {
        this.resourceManager = resourceManager;
        this.passwordFile = new File(System.getProperty("user.home"), "passwd.antxconfig");
    }

    public AuthenticationHandler.UsernamePassword authenticate(String message, URI uri, String username, boolean visited) {
        String password;
        AuthenticationHandler.UsernamePassword userPass;
        if (!visited && (userPass = this.loadPassword(uri)) != null) {
            return userPass;
        }
        this.resourceManager.getOut().println(message);
        try {
            while (StringUtil.isEmpty(username)) {
                this.resourceManager.getOut().print("Enter Username: ");
                this.resourceManager.getOut().flush();
                username = StringUtil.trimWhitespace(this.resourceManager.getIn().readLine());
            }
            password = new PasswordField().getPassword(this.resourceManager.getOut(), "Enter Password: ", message);
        }
        catch (IOException e) {
            throw new ConfigException(e);
        }
        this.savePassword(uri, username, password);
        return new AuthenticationHandler.UsernamePassword(username, password);
    }

    private AuthenticationHandler.UsernamePassword loadPassword(URI uri) {
        String userPass;
        String key;
        Properties passwords = this.loadPasswordFile();
        String encodedPassword = (String)passwords.get(key = this.getKey(uri));
        if (encodedPassword == null) {
            return null;
        }
        try {
            userPass = new String(Base64.decodeBase64(encodedPassword.getBytes("8859_1")), "8859_1");
        }
        catch (Exception e) {
            throw new ConfigException(e);
        }
        int index = userPass.indexOf(":");
        String user = null;
        String pass = null;
        if (index < 0) {
            return null;
        }
        user = userPass.substring(0, index);
        pass = userPass.substring(index + 1);
        return new AuthenticationHandler.UsernamePassword(user, pass);
    }

    private void savePassword(URI uri, String username, String password) {
        try {
            Properties passwords = this.loadPasswordFile();
            String key = this.getKey(uri);
            String userPass = username + ":" + password;
            String encodedPassword = new String(Base64.encodeBase64(userPass.getBytes("8859_1")), "8859_1");
            passwords.put(key, encodedPassword);
            boolean succ = this.savePasswordFile(passwords);
            if (!succ) {
                throw new ConfigException("Cannot save file: " + this.passwordFile.getAbsolutePath());
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConfigException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Properties loadPasswordFile() {
        Properties passwords = new Properties();
        FileInputStream is = null;
        is = new FileInputStream(this.passwordFile);
        passwords.load(is);
        Object var5_3 = null;
        if (is == null) return passwords;
        try {
            ((InputStream)is).close();
            return passwords;
        }
        catch (IOException e) {}
        return passwords;
        {
            catch (Exception exception) {
                Object var5_4 = null;
                if (is == null) return passwords;
                try {
                    ((InputStream)is).close();
                    return passwords;
                }
                catch (IOException e) {}
                return passwords;
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (is == null) throw throwable;
            try {
                ((InputStream)is).close();
                throw throwable;
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean savePasswordFile(Properties passwords) throws IOException, FileNotFoundException {
        File tmp;
        block5: {
            tmp = File.createTempFile(this.passwordFile.getName() + ".", ".tmp", this.passwordFile.getParentFile());
            FileOutputStream os = null;
            tmp.deleteOnExit();
            try {
                os = new FileOutputStream(tmp);
                passwords.store(os, "Passwords for antxconfig");
                Object var5_4 = null;
                if (os == null) break block5;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                if (os == null) throw throwable;
                try {
                    ((OutputStream)os).close();
                    throw throwable;
                }
                catch (IOException e) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (IOException e) {}
            ((OutputStream)os).close();
        }
        this.passwordFile.delete();
        return tmp.renameTo(this.passwordFile);
    }

    private String getKey(URI uri) {
        StringBuffer buf = new StringBuffer();
        buf.append(uri.getScheme()).append("://");
        String user = ResourceUtil.getUsername(uri);
        if (!StringUtil.isEmpty(user)) {
            buf.append(user).append("@");
        }
        buf.append(uri.getHost());
        if (uri.getPort() > 0) {
            buf.append(":").append(uri.getPort());
        }
        return buf.toString();
    }
}

