/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.antx.config.resource.file;

import com.alibaba.antx.config.ConfigException;
import com.alibaba.antx.config.resource.Resource;
import com.alibaba.antx.config.resource.ResourceNotFoundException;
import com.alibaba.antx.config.resource.ResourceURI;
import com.alibaba.antx.config.resource.Session;
import com.alibaba.antx.util.StreamUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class FileResource
extends Resource {
    private File file;

    public FileResource(Session session, ResourceURI uri) {
        super(session, uri);
        this.file = uri.getFile();
    }

    public Resource getRelatedResource(String suburi) {
        return new FileResource(this.getSession(), this.getURI().getSubURI(suburi));
    }

    public byte[] getContent() {
        try {
            return StreamUtil.readBytes(this.getInputStream(), true).toByteArray();
        }
        catch (IOException e) {
            throw new ConfigException(e);
        }
    }

    public InputStream getInputStream() {
        try {
            return new FileInputStream(this.file);
        }
        catch (FileNotFoundException e) {
            throw new ResourceNotFoundException(e);
        }
    }

    public OutputStream getOutputStream() {
        try {
            return new FileOutputStream(this.file);
        }
        catch (FileNotFoundException e) {
            throw new ResourceNotFoundException(e);
        }
    }

    public boolean isDirectory() {
        return this.file.isDirectory();
    }

    public List list() {
        if (!this.isDirectory()) {
            return null;
        }
        File[] subfiles = this.file.listFiles();
        ArrayList<FileResource> files = new ArrayList<FileResource>(subfiles.length);
        for (File subfile : subfiles) {
            FileResource resource = new FileResource(this.getSession(), new ResourceURI(subfile.toURI(), this.getSession()));
            files.add(resource);
        }
        Collections.sort(files);
        return files;
    }
}

