/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.antx.config.resource.http;

import com.alibaba.antx.config.ConfigException;
import com.alibaba.antx.config.resource.Resource;
import com.alibaba.antx.config.resource.ResourceNotFoundException;
import com.alibaba.antx.config.resource.ResourceURI;
import com.alibaba.antx.config.resource.http.HttpSession;
import com.alibaba.antx.config.resource.util.ApacheIndexPageParser;
import com.alibaba.antx.config.resource.util.IndexPageParser;
import com.alibaba.antx.config.resource.util.ResourceContext;
import com.alibaba.antx.config.resource.util.ResourceKey;
import com.alibaba.antx.config.resource.util.SvnIndexPageParser;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpStatus;
import org.apache.commons.httpclient.methods.GetMethod;

public class HttpResource
extends Resource {
    private byte[] content;
    private String charset;
    private String contentType;

    public HttpResource(HttpSession session, ResourceURI uri) {
        super(session, uri);
    }

    public Resource getRelatedResource(String suburi) {
        return new HttpResource((HttpSession)this.getSession(), this.getURI().getSubURI(suburi));
    }

    public String getContentType() {
        this.load();
        return this.contentType;
    }

    public String getCharset() {
        this.load();
        return this.charset;
    }

    public byte[] getContent() {
        this.load();
        return this.content;
    }

    /*
     * Loose catch block
     */
    private void load() {
        GetMethod httpget;
        block11: {
            if (this.content != null) {
                return;
            }
            httpget = new GetMethod(this.getURI().toString());
            httpget.setDoAuthentication(true);
            InputStream stream = null;
            ResourceContext.get().setCurrentURI(this.getURI().getURI());
            ((HttpSession)this.getSession()).getClient().executeMethod(httpget);
            if (httpget.getStatusCode() != 200) {
                throw new ResourceNotFoundException(HttpStatus.getStatusText(httpget.getStatusCode()));
            }
            ResourceContext.get().getVisitedURIs().remove(new ResourceKey(new ResourceURI(this.getURI().getURI())));
            this.content = httpget.getResponseBody();
            this.charset = httpget.getResponseCharSet();
            Header contentTypeHeader = httpget.getResponseHeader("Content-Type");
            this.contentType = contentTypeHeader == null ? null : contentTypeHeader.getValue();
            Object var5_6 = null;
            ResourceContext.get().setCurrentURI(null);
            if (stream == null) break block11;
            try {
                stream.close();
                break block11;
            }
            catch (IOException e) {
                // empty catch block
            }
            {
                break block11;
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new ConfigException(e);
                }
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                ResourceContext.get().setCurrentURI(null);
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                httpget.releaseConnection();
                throw throwable;
            }
        }
        httpget.releaseConnection();
    }

    public InputStream getInputStream() {
        return new ByteArrayInputStream(this.getContent());
    }

    public OutputStream getOutputStream() {
        throw new UnsupportedOperationException();
    }

    public boolean isDirectory() {
        return this.getURI().guessDirectory();
    }

    public List list() {
        if (this.isDirectory()) {
            IndexPageParser parser;
            String overridingCharset = this.getURI().getOption("charset");
            IndexPageParser[] parsers = new IndexPageParser[]{new SvnIndexPageParser(), new ApacheIndexPageParser(overridingCharset)};
            List items = null;
            IndexPageParser[] arr$ = parsers;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$ && (items = (parser = arr$[i$]).parse(this)) == null; ++i$) {
            }
            if (items != null) {
                ListIterator<HttpResource> i = items.listIterator();
                while (i.hasNext()) {
                    IndexPageParser.Item item = (IndexPageParser.Item)i.next();
                    HttpResource resource = new HttpResource((HttpSession)this.getSession(), this.getURI().getSubURI(item.getName(), item.isDirectory()));
                    i.set(resource);
                }
            }
            return items;
        }
        return null;
    }
}

