/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.antx.config.resource.ssh;

import com.alibaba.antx.config.ConfigException;
import com.alibaba.antx.config.resource.Resource;
import com.alibaba.antx.config.resource.ResourceURI;
import com.alibaba.antx.config.resource.Session;
import com.alibaba.antx.util.StreamUtil;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.SftpATTRS;
import com.jcraft.jsch.SftpException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Vector;

public class SshResource
extends Resource {
    private final ChannelSftp channel;
    private final SftpATTRS attrs;

    public SshResource(Session session, ChannelSftp channel, ResourceURI uri, SftpATTRS attrs) {
        super(session, uri);
        this.channel = channel;
        this.attrs = attrs;
    }

    public Resource getRelatedResource(String suburi) {
        return new SshResource(this.getSession(), this.channel, this.getURI().getSubURI(suburi), null);
    }

    public byte[] getContent() {
        this.assertFile();
        try {
            return StreamUtil.readBytes(this.getInputStream(), true).toByteArray();
        }
        catch (IOException e) {
            throw new ConfigException(e);
        }
    }

    public InputStream getInputStream() {
        this.assertFile();
        try {
            return this.channel.get(this.getURI().getPath());
        }
        catch (SftpException e) {
            throw new ConfigException(e);
        }
    }

    public OutputStream getOutputStream() {
        this.assertFile();
        try {
            return this.channel.put(this.getURI().getPath());
        }
        catch (SftpException e) {
            throw new ConfigException(e);
        }
    }

    public String getCharset() {
        return null;
    }

    public String getContentType() {
        return null;
    }

    public boolean isDirectory() {
        if (this.attrs == null) {
            return this.getURI().guessDirectory();
        }
        return this.attrs.isDir();
    }

    public List list() {
        Vector entries;
        this.assertDirectory();
        try {
            entries = this.channel.ls(this.getURI().getPath());
        }
        catch (SftpException e) {
            throw new ConfigException(e);
        }
        ArrayList<SshResource> result = new ArrayList<SshResource>(entries.size());
        for (ChannelSftp.LsEntry entry : entries) {
            String name = entry.getFilename();
            if (".".equals(name) || "..".equals(name)) continue;
            result.add(new SshResource(this.getSession(), this.channel, this.getURI().getSubURI(name, entry.getAttrs().isDir()), entry.getAttrs()));
        }
        Collections.sort(result);
        return result;
    }
}

