/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.toolkit.util.resourcebundle;

import com.alibaba.toolkit.util.ContextClassLoader;
import com.alibaba.toolkit.util.resourcebundle.ResourceBundleCreateException;
import com.alibaba.toolkit.util.resourcebundle.ResourceBundleLoader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

public class ClassLoaderResourceBundleLoader
implements ResourceBundleLoader {
    private ClassLoader classLoader;

    public ClassLoaderResourceBundleLoader() {
        this(null);
    }

    public ClassLoaderResourceBundleLoader(ClassLoader classLoader) {
        if (classLoader == null) {
            this.classLoader = ContextClassLoader.getClassLoader();
            if (this.classLoader == null) {
                this.classLoader = ClassLoader.getSystemClassLoader();
            }
        } else {
            this.classLoader = classLoader;
        }
    }

    public InputStream openStream(final String bundleFilename) throws ResourceBundleCreateException {
        try {
            return (InputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws ResourceBundleCreateException {
                    URL url = ClassLoaderResourceBundleLoader.this.classLoader.getResource(bundleFilename);
                    if (url == null) {
                        return null;
                    }
                    try {
                        return url.openStream();
                    }
                    catch (IOException e) {
                        throw new ResourceBundleCreateException("Could not open stream for resource \"{0}\"", new Object[]{bundleFilename}, e);
                    }
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (ResourceBundleCreateException)e.getException();
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ClassLoaderResourceBundleLoader)) {
            return false;
        }
        return ((ClassLoaderResourceBundleLoader)obj).classLoader == this.classLoader;
    }

    public int hashCode() {
        return this.classLoader == null ? 0 : this.classLoader.hashCode();
    }
}

