/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.toolkit.util.resourcebundle;

import com.alibaba.toolkit.util.collection.SoftHashMap;
import com.alibaba.toolkit.util.resourcebundle.ResourceBundle;
import com.alibaba.toolkit.util.resourcebundle.ResourceBundleCreateException;
import com.alibaba.toolkit.util.resourcebundle.ResourceBundleException;
import com.alibaba.toolkit.util.resourcebundle.ResourceBundleLoader;
import com.alibaba.toolkit.util.resourcebundle.xml.XMLResourceBundleFactory;
import java.lang.ref.SoftReference;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public abstract class ResourceBundleFactory {
    public static final ResourceBundle getBundle(String baseName) {
        return ResourceBundleFactory.getBundle(baseName, null, (ResourceBundleFactory)null);
    }

    public static final ResourceBundle getBundle(String baseName, Locale locale) {
        return ResourceBundleFactory.getBundle(baseName, locale, (ResourceBundleFactory)null);
    }

    public static final ResourceBundle getBundle(String baseName, Locale locale, ClassLoader classLoader) {
        return ResourceBundleFactory.getBundle(baseName, locale, new XMLResourceBundleFactory(classLoader));
    }

    public static final ResourceBundle getBundle(String baseName, Locale locale, ResourceBundleLoader loader) {
        return ResourceBundleFactory.getBundle(baseName, locale, new XMLResourceBundleFactory(loader));
    }

    public static final ResourceBundle getBundle(String baseName, Locale locale, ResourceBundleFactory factory) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if (factory == null) {
            factory = new XMLResourceBundleFactory();
        }
        return Helper.getBundleImpl(baseName, locale, factory);
    }

    public abstract ResourceBundle createBundle(String var1) throws ResourceBundleCreateException;

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    private static final class CacheKey
    implements Cloneable {
        private SoftReference factoryRef;
        private String bundleName;
        private Locale defaultLocale;
        private int hashCode;

        private CacheKey() {
        }

        public void set(ResourceBundleFactory factory, String bundleName, Locale defaultLocale) {
            this.bundleName = bundleName;
            this.hashCode = bundleName.hashCode();
            this.defaultLocale = defaultLocale;
            if (defaultLocale != null) {
                this.hashCode ^= defaultLocale.hashCode();
            }
            if (factory == null) {
                this.factoryRef = null;
            } else {
                this.factoryRef = new SoftReference<ResourceBundleFactory>(factory);
                this.hashCode ^= factory.hashCode();
            }
        }

        public void clear() {
            this.set(null, "", null);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            try {
                CacheKey otherKey = (CacheKey)other;
                if (this.hashCode != otherKey.hashCode) {
                    return false;
                }
                if (!this.eq(this.bundleName, otherKey.bundleName)) {
                    return false;
                }
                if (!this.eq(this.defaultLocale, otherKey.defaultLocale)) {
                    return false;
                }
                if (this.factoryRef == null) {
                    return otherKey.factoryRef == null;
                }
                return otherKey.factoryRef != null && this.eq(this.factoryRef.get(), otherKey.factoryRef.get());
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        private boolean eq(Object o1, Object o2) {
            return o1 == null ? o2 == null : o1.equals(o2);
        }

        public int hashCode() {
            return this.hashCode;
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new InternalError(MessageFormat.format("Clone is not supported by class \"{0}\"", CacheKey.class.getName()));
            }
        }

        public String toString() {
            return new StringBuffer("CacheKey[factory=").append((Object)(this.factoryRef == null ? "null" : this.factoryRef.get())).append(", bundleName=").append(this.bundleName).append(", defaultLocale=").append(this.defaultLocale).append("]").toString();
        }
    }

    private static final class Cache
    extends SoftHashMap {
        private static final CacheKey cacheKey = new CacheKey();
        private final Map underConstruction = new HashMap(3, 1.0f);

        public Cache() {
            super(25, 1.0f);
        }

        public synchronized Object get(ResourceBundleFactory factory, String bundleName, Locale defaultLocale) {
            cacheKey.set(factory, bundleName, defaultLocale);
            Object result = this.get(cacheKey);
            cacheKey.clear();
            return result;
        }

        public synchronized Object getWait(ResourceBundleFactory factory, String bundleName, Locale defaultLocale) {
            boolean beingBuilt;
            cacheKey.set(factory, bundleName, defaultLocale);
            Object result = this.get(cacheKey);
            if (result != null) {
                cacheKey.clear();
                return result;
            }
            Thread builder = (Thread)this.underConstruction.get(cacheKey);
            boolean bl = beingBuilt = builder != null && builder != Thread.currentThread();
            if (beingBuilt) {
                while (beingBuilt) {
                    cacheKey.clear();
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    cacheKey.set(factory, bundleName, defaultLocale);
                    beingBuilt = this.underConstruction.containsKey(cacheKey);
                }
                result = this.get(cacheKey);
                if (result != null) {
                    cacheKey.clear();
                    return result;
                }
            }
            this.underConstruction.put(cacheKey.clone(), Thread.currentThread());
            cacheKey.clear();
            return null;
        }

        public synchronized void put(ResourceBundleFactory factory, String bundleName, Locale defaultLocale, Object bundle) {
            cacheKey.set(factory, bundleName, defaultLocale);
            this.put(cacheKey.clone(), bundle);
            this.underConstruction.remove(cacheKey);
            cacheKey.clear();
            this.notifyAll();
        }

        public synchronized void cleanUpConstructionList() {
            Collection entries = this.underConstruction.values();
            Thread thisThread = Thread.currentThread();
            while (entries.remove(thisThread)) {
            }
            this.notifyAll();
        }
    }

    private static final class Helper {
        private static final Cache cache = new Cache();

        private Helper() {
        }

        private static ResourceBundle getBundleImpl(String baseName, Locale locale, ResourceBundleFactory factory) {
            if (baseName == null) {
                throw new NullPointerException("The basename of the resource bundle should not be null");
            }
            ResourceBundleFactory NOT_FOUND = factory;
            String bundleName = baseName;
            String localeSuffix = locale.toString();
            if (localeSuffix.length() > 0) {
                bundleName = bundleName + "_" + localeSuffix;
            } else if (locale.getVariant().length() > 0) {
                bundleName = bundleName + "___" + locale.getVariant();
            }
            Locale defaultLocale = Locale.getDefault();
            Object lookup = cache.get(factory, bundleName, defaultLocale);
            if (((Object)NOT_FOUND).equals(lookup)) {
                Helper.throwResourceBundleException(true, baseName, locale, null);
            } else if (lookup != null) {
                return (ResourceBundle)lookup;
            }
            Object parent = NOT_FOUND;
            try {
                int i;
                boolean foundInMainBranch;
                Object root = Helper.findBundle(factory, baseName, defaultLocale, baseName, null, NOT_FOUND);
                if (root == null) {
                    root = NOT_FOUND;
                    cache.put(factory, baseName, defaultLocale, root);
                }
                List names = Helper.calculateBundleNames(baseName, locale);
                ArrayList<Object> bundlesFound = new ArrayList<Object>(3);
                boolean bl = foundInMainBranch = !((Object)NOT_FOUND).equals(root) && names.size() == 0;
                if (!foundInMainBranch) {
                    parent = root;
                    for (i = 0; i < names.size(); ++i) {
                        bundleName = (String)names.get(i);
                        lookup = Helper.findBundle(factory, bundleName, defaultLocale, baseName, parent, NOT_FOUND);
                        bundlesFound.add(lookup);
                        if (lookup == null) continue;
                        parent = lookup;
                        foundInMainBranch = true;
                    }
                }
                parent = root;
                if (!foundInMainBranch) {
                    List fallbackNames = Helper.calculateBundleNames(baseName, defaultLocale);
                    for (int i2 = 0; i2 < fallbackNames.size() && !names.contains(bundleName = (String)fallbackNames.get(i2)); ++i2) {
                        lookup = Helper.findBundle(factory, bundleName, defaultLocale, baseName, parent, NOT_FOUND);
                        if (lookup != null) {
                            parent = lookup;
                            continue;
                        }
                        cache.put(factory, bundleName, defaultLocale, parent);
                    }
                }
                for (i = 0; i < names.size(); ++i) {
                    String name = (String)names.get(i);
                    Object bundleFound = bundlesFound.get(i);
                    if (bundleFound == null) {
                        cache.put(factory, name, defaultLocale, parent);
                        continue;
                    }
                    parent = bundleFound;
                }
            }
            catch (Exception e) {
                cache.cleanUpConstructionList();
                Helper.throwResourceBundleException(false, baseName, locale, e);
            }
            catch (Error e) {
                cache.cleanUpConstructionList();
                throw e;
            }
            if (((Object)NOT_FOUND).equals(parent)) {
                Helper.throwResourceBundleException(true, baseName, locale, null);
            }
            return (ResourceBundle)parent;
        }

        private static Object findBundle(ResourceBundleFactory factory, String bundleName, Locale defaultLocale, String baseName, Object parent, Object NOT_FOUND) throws ResourceBundleCreateException {
            Object result = cache.getWait(factory, bundleName, defaultLocale);
            if (result != null) {
                return result;
            }
            result = factory.createBundle(bundleName);
            if (result != null) {
                Object otherBundle = cache.get(factory, bundleName, defaultLocale);
                if (otherBundle != null) {
                    result = otherBundle;
                } else {
                    ResourceBundle bundle = (ResourceBundle)result;
                    if (!NOT_FOUND.equals(parent) && bundle.getParent() == null) {
                        bundle.setParent((ResourceBundle)parent);
                    }
                    bundle.setBaseName(baseName);
                    bundle.setLocale(baseName, bundleName);
                    cache.put(factory, bundleName, defaultLocale, result);
                }
            }
            return result;
        }

        private static List calculateBundleNames(String baseName, Locale locale) {
            String variant;
            int variantLength;
            String country;
            int countryLength;
            ArrayList<String> result = new ArrayList<String>(3);
            String language = locale.getLanguage();
            int languageLength = language.length();
            if (languageLength + (countryLength = (country = locale.getCountry()).length()) + (variantLength = (variant = locale.getVariant()).length()) == 0) {
                return result;
            }
            StringBuffer buffer = new StringBuffer(baseName);
            buffer.append('_');
            buffer.append(language);
            if (languageLength > 0) {
                result.add(buffer.toString());
            }
            if (countryLength + variantLength == 0) {
                return result;
            }
            buffer.append('_');
            buffer.append(country);
            if (countryLength > 0) {
                result.add(buffer.toString());
            }
            if (variantLength == 0) {
                return result;
            }
            buffer.append('_');
            buffer.append(variant);
            result.add(buffer.toString());
            return result;
        }

        private static void throwResourceBundleException(boolean missing, String baseName, Locale locale, Throwable cause) {
            String bundleName = baseName + "_" + locale;
            if (missing) {
                throw new ResourceBundleException("Could not find bundle for base name \"{0}\", locale \"{1}\"", new Object[]{baseName, locale}, cause, bundleName, "");
            }
            throw new ResourceBundleException("Failed to load bundle for base name \"{0}\", locale \"{1}\"", new Object[]{baseName, locale}, cause, bundleName, "");
        }
    }
}

