/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.toolkit.util.typeconvert.converters;

import com.alibaba.toolkit.util.typeconvert.ConvertChain;
import com.alibaba.toolkit.util.typeconvert.ConvertFailedException;
import com.alibaba.toolkit.util.typeconvert.Converter;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class BooleanConverter
implements Converter {
    protected static final Boolean DEFAULT_VALUE = Boolean.FALSE;
    protected static final Set TRUE_STRINGS = new HashSet<String>(Arrays.asList("true", "on", "yes", "y"));
    protected static final Set FALSE_STRINGS = new HashSet<String>(Arrays.asList("false", "null", "nul", "nil", "off", "no", "n"));

    public Object convert(Object value, ConvertChain chain) {
        if (value == null) {
            throw new ConvertFailedException().setDefaultValue(DEFAULT_VALUE);
        }
        if (value instanceof Boolean) {
            return value;
        }
        if (value instanceof Number) {
            return Math.abs(((Number)value).doubleValue()) < (double)1.4E-45f ? Boolean.FALSE : Boolean.TRUE;
        }
        if (value instanceof String) {
            String strValue = ((String)value).trim();
            try {
                return Integer.decode(strValue) == 0 ? Boolean.FALSE : Boolean.TRUE;
            }
            catch (NumberFormatException e) {
                if (strValue.length() == 0) {
                    throw new ConvertFailedException().setDefaultValue(DEFAULT_VALUE);
                }
                if (TRUE_STRINGS.contains(strValue = strValue.toLowerCase())) {
                    return Boolean.TRUE;
                }
                if (FALSE_STRINGS.contains(strValue)) {
                    return Boolean.FALSE;
                }
                throw new ConvertFailedException(e);
            }
        }
        return chain.convert(value);
    }
}

