/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.tidy;

import java.io.IOException;
import org.w3c.tidy.Out;

public class OutImpl
extends Out {
    private static final byte[] nlBytes = System.getProperty("line.separator").getBytes();

    public OutImpl() {
        this.out = null;
    }

    public void outc(byte c) {
        this.outc(c & 0xFF);
    }

    public void outc(int c) {
        try {
            if (this.encoding == 3) {
                if (c < 128) {
                    this.out.write(c);
                } else if (c <= 2047) {
                    int ch = 0xC0 | c >> 6;
                    this.out.write(ch);
                    ch = 0x80 | c & 0x3F;
                    this.out.write(ch);
                } else if (c <= 65535) {
                    int ch = 0xE0 | c >> 12;
                    this.out.write(ch);
                    ch = 0x80 | c >> 6 & 0x3F;
                    this.out.write(ch);
                    ch = 0x80 | c & 0x3F;
                    this.out.write(ch);
                } else if (c <= 0x1FFFFF) {
                    int ch = 0xF0 | c >> 18;
                    this.out.write(ch);
                    ch = 0x80 | c >> 12 & 0x3F;
                    this.out.write(ch);
                    ch = 0x80 | c >> 6 & 0x3F;
                    this.out.write(ch);
                    ch = 0x80 | c & 0x3F;
                    this.out.write(ch);
                } else {
                    int ch = 0xF8 | c >> 24;
                    this.out.write(ch);
                    ch = 0x80 | c >> 18 & 0x3F;
                    this.out.write(ch);
                    ch = 0x80 | c >> 12 & 0x3F;
                    this.out.write(ch);
                    ch = 0x80 | c >> 6 & 0x3F;
                    this.out.write(ch);
                    ch = 0x80 | c & 0x3F;
                    this.out.write(ch);
                }
            } else if (this.encoding == 4) {
                if (c == 27) {
                    this.state = 1;
                } else {
                    switch (this.state) {
                        case 1: {
                            if (c == 36) {
                                this.state = 2;
                                break;
                            }
                            if (c == 40) {
                                this.state = 4;
                                break;
                            }
                            this.state = 0;
                            break;
                        }
                        case 2: {
                            if (c == 40) {
                                this.state = 3;
                                break;
                            }
                            this.state = 5;
                            break;
                        }
                        case 3: {
                            this.state = 5;
                            break;
                        }
                        case 4: {
                            this.state = 0;
                            break;
                        }
                        case 5: {
                            c &= 0x7F;
                        }
                    }
                }
                this.out.write(c);
            } else {
                this.out.write(c);
            }
        }
        catch (IOException e) {
            System.err.println("OutImpl.outc: " + e.toString());
        }
    }

    public void newline() {
        try {
            this.out.write(nlBytes);
            this.out.flush();
        }
        catch (IOException e) {
            System.err.println("OutImpl.newline: " + e.toString());
        }
    }
}

