/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.tidy;

import java.io.IOException;
import java.io.InputStream;
import org.w3c.tidy.Lexer;
import org.w3c.tidy.Report;
import org.w3c.tidy.StreamIn;

public class StreamInImpl
extends StreamIn {
    private static int[] Win2Unicode = new int[]{8364, 0, 8218, 402, 8222, 8230, 8224, 8225, 710, 8240, 352, 8249, 338, 0, 381, 0, 0, 8216, 8217, 8220, 8221, 8226, 8211, 8212, 732, 8482, 353, 8250, 339, 0, 382, 376};
    private static int[] Mac2Unicode = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 196, 197, 199, 201, 209, 214, 220, 225, 224, 226, 228, 227, 229, 231, 233, 232, 234, 235, 237, 236, 238, 239, 241, 243, 242, 244, 246, 245, 250, 249, 251, 252, 8224, 176, 162, 163, 167, 8226, 182, 223, 174, 169, 8482, 180, 168, 8800, 198, 216, 8734, 177, 8804, 8805, 165, 181, 8706, 8721, 8719, 960, 8747, 170, 186, 937, 230, 248, 191, 161, 172, 8730, 402, 8776, 8710, 171, 187, 8230, 160, 192, 195, 213, 338, 339, 8211, 8212, 8220, 8221, 8216, 8217, 247, 9674, 255, 376, 8260, 8364, 8249, 8250, 64257, 64258, 8225, 183, 8218, 8222, 8240, 194, 202, 193, 203, 200, 205, 206, 207, 204, 211, 212, 63743, 210, 218, 219, 217, 305, 710, 732, 175, 728, 729, 730, 184, 733, 731, 711};

    public StreamInImpl(InputStream stream, int encoding, int tabsize) {
        this.stream = stream;
        this.pushed = false;
        this.c = 0;
        this.tabs = 0;
        this.tabsize = tabsize;
        this.curline = 1;
        this.curcol = 1;
        this.encoding = encoding;
        this.state = 0;
        this.endOfStream = false;
    }

    public int readCharFromStream() {
        int n;
        try {
            int count;
            int c = this.stream.read();
            if (c == -1) {
                this.endOfStream = true;
                return c;
            }
            if (this.encoding == 4) {
                if (c == 27) {
                    this.state = 1;
                    return c;
                }
                switch (this.state) {
                    case 1: {
                        if (c == 36) {
                            this.state = 2;
                            break;
                        }
                        if (c == 40) {
                            this.state = 4;
                            break;
                        }
                        this.state = 0;
                        break;
                    }
                    case 2: {
                        if (c == 40) {
                            this.state = 3;
                            break;
                        }
                        this.state = 5;
                        break;
                    }
                    case 3: {
                        this.state = 5;
                        break;
                    }
                    case 4: {
                        this.state = 0;
                        break;
                    }
                    case 5: {
                        c |= 0x80;
                    }
                }
                return c;
            }
            if (this.encoding != 3) {
                return c;
            }
            if ((c & 0xE0) == 192) {
                n = c & 0x1F;
                count = 1;
            } else if ((c & 0xF0) == 224) {
                n = c & 0xF;
                count = 2;
            } else if ((c & 0xF8) == 240) {
                n = c & 7;
                count = 3;
            } else if ((c & 0xFC) == 248) {
                n = c & 3;
                count = 4;
            } else if ((c & 0xFE) == 252) {
                n = c & 1;
                count = 5;
            } else {
                return c;
            }
            for (int i = 1; i <= count; ++i) {
                c = this.stream.read();
                if (c == -1) {
                    this.endOfStream = true;
                    return c;
                }
                n = n << 6 | c & 0x3F;
            }
        }
        catch (IOException e) {
            System.err.println("StreamInImpl.readCharFromStream: " + e.toString());
            n = -1;
        }
        return n;
    }

    public int readChar() {
        int c;
        block11: {
            if (this.pushed) {
                this.pushed = false;
                int c2 = this.c;
                if (c2 == 10) {
                    this.curcol = 1;
                    ++this.curline;
                    return c2;
                }
                ++this.curcol;
                return c2;
            }
            this.lastcol = this.curcol++;
            if (this.tabs > 0) {
                --this.tabs;
                return 32;
            }
            while (true) {
                if ((c = this.readCharFromStream()) < 0) {
                    return -1;
                }
                if (c == 10) {
                    this.curcol = 1;
                    ++this.curline;
                    break block11;
                }
                if (c == 13) {
                    c = this.readCharFromStream();
                    if (c != 10) {
                        this.ungetChar(c);
                        c = 10;
                    }
                    this.curcol = 1;
                    ++this.curline;
                    break block11;
                }
                if (c == 9) {
                    this.tabs = this.tabsize - (this.curcol - 1) % this.tabsize - 1;
                    ++this.curcol;
                    c = 32;
                    break block11;
                }
                if (c == 27) break block11;
                if (0 < c && c < 32) continue;
                if (this.encoding == 0 || this.encoding == 4) {
                    ++this.curcol;
                    break block11;
                }
                if (this.encoding == 5) {
                    c = Mac2Unicode[c];
                }
                if (127 >= c || c >= 160) break;
                Report.encodingError((Lexer)this.lexer, (short)1, c);
                c = Win2Unicode[c - 128];
                if (c != 0) break;
            }
            ++this.curcol;
        }
        return c;
    }

    public void ungetChar(int c) {
        this.pushed = true;
        this.c = c;
        if (c == 10) {
            --this.curline;
        }
        this.curcol = this.lastcol;
    }

    public boolean isEndOfStream() {
        return this.endOfStream;
    }
}

