/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.antx.util.configuration;

import com.alibaba.antx.util.configuration.Configuration;
import com.alibaba.antx.util.configuration.ConfigurationException;
import com.alibaba.antx.util.configuration.NamespacedSAXConfigurationHandler;
import com.alibaba.antx.util.configuration.SAXConfigurationHandler;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class DefaultConfigurationBuilder {
    private SAXConfigurationHandler m_handler;
    private XMLReader m_parser;

    public DefaultConfigurationBuilder() {
        this(false);
    }

    public DefaultConfigurationBuilder(boolean enableNamespaces) {
        try {
            SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
            if (enableNamespaces) {
                saxParserFactory.setNamespaceAware(true);
            }
            SAXParser saxParser = saxParserFactory.newSAXParser();
            this.setParser(saxParser.getXMLReader());
        }
        catch (Exception se) {
            throw new Error("Unable to setup SAX parser" + se);
        }
    }

    public DefaultConfigurationBuilder(XMLReader parser) {
        this.setParser(parser);
    }

    private void setParser(XMLReader parser) {
        this.m_parser = parser;
        this.m_handler = this.getHandler();
        this.m_parser.setContentHandler(this.m_handler);
        this.m_parser.setErrorHandler(this.m_handler);
    }

    protected SAXConfigurationHandler getHandler() {
        try {
            if (this.m_parser.getFeature("http://xml.org/sax/features/namespaces")) {
                return new NamespacedSAXConfigurationHandler();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new SAXConfigurationHandler();
    }

    public Configuration buildFromFile(String filename) throws SAXException, IOException, ConfigurationException {
        return this.buildFromFile(new File(filename));
    }

    public Configuration buildFromFile(File file) throws SAXException, IOException, ConfigurationException {
        return this.buildFromURL(file.toURI().toURL());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Configuration buildFromURL(URL url) throws SAXException, IOException, ConfigurationException {
        DefaultConfigurationBuilder defaultConfigurationBuilder = this;
        synchronized (defaultConfigurationBuilder) {
            this.m_handler.clear();
            this.m_parser.parse(url.toString());
            return this.m_handler.getConfiguration();
        }
    }

    public Configuration build(InputStream inputStream) throws SAXException, IOException, ConfigurationException {
        return this.build(new InputSource(inputStream));
    }

    public Configuration build(String uri) throws SAXException, IOException, ConfigurationException {
        return this.build(new InputSource(uri));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Configuration build(InputSource input) throws SAXException, IOException, ConfigurationException {
        DefaultConfigurationBuilder defaultConfigurationBuilder = this;
        synchronized (defaultConfigurationBuilder) {
            this.m_handler.clear();
            this.m_parser.parse(input);
            return this.m_handler.getConfiguration();
        }
    }
}

