/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.toolkit.util.enumeration;

import com.alibaba.toolkit.util.enumeration.Enum;

public abstract class IntegerEnum
extends Enum {
    private static final long serialVersionUID = 343392921439669443L;

    protected IntegerEnum(String name) {
        super(name);
    }

    protected IntegerEnum(String name, int value) {
        super(name, new Integer(value));
    }

    protected static Object createEnumType() {
        return new Enum.EnumType(){

            protected Class getUnderlyingClass() {
                return Integer.class;
            }

            protected Object getNextValue(Object value, boolean flagMode) {
                if (value == null) {
                    return flagMode ? new Integer(1) : new Integer(0);
                }
                int intValue = (Integer)value;
                if (flagMode) {
                    return new Integer(intValue << 1);
                }
                return new Integer(intValue + 1);
            }

            protected boolean isZero(Object value) {
                return (Integer)value == 0;
            }

            protected boolean isPowerOfTwo(Object value) {
                int intValue = (Integer)value;
                if (intValue == 0) {
                    return false;
                }
                while ((intValue & 1) == 0) {
                    intValue >>>= 1;
                }
                return intValue == 1;
            }
        };
    }

    public int intValue() {
        return (Integer)this.getValue();
    }

    public long longValue() {
        return ((Integer)this.getValue()).longValue();
    }

    public double doubleValue() {
        return ((Integer)this.getValue()).doubleValue();
    }

    public float floatValue() {
        return ((Integer)this.getValue()).floatValue();
    }

    public String toHexString() {
        return Integer.toHexString((Integer)this.getValue());
    }

    public String toOctalString() {
        return Integer.toOctalString((Integer)this.getValue());
    }

    public String toBinaryString() {
        return Integer.toBinaryString((Integer)this.getValue());
    }
}

