/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.toolkit.util.resourcebundle;

import com.alibaba.toolkit.util.StringUtil;
import com.alibaba.toolkit.util.resourcebundle.ResourceBundleFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;

public class MessageBuilder {
    protected final List params = new ArrayList(5);
    protected final ResourceBundle bundle;
    protected final Object key;

    public MessageBuilder(String bundleName, Object key) {
        this(ResourceBundleFactory.getBundle(bundleName), key);
    }

    public MessageBuilder(ResourceBundle bundle, Object key) {
        this.bundle = bundle;
        this.key = key;
    }

    public MessageBuilder append(Object param) {
        this.params.add(param);
        return this;
    }

    public MessageBuilder append(boolean param) {
        this.params.add(new Boolean(param));
        return this;
    }

    public MessageBuilder append(char param) {
        this.params.add(new Character(param));
        return this;
    }

    public MessageBuilder append(double param) {
        this.params.add(new Double(param));
        return this;
    }

    public MessageBuilder append(float param) {
        this.params.add(new Float(param));
        return this;
    }

    public MessageBuilder append(int param) {
        this.params.add(new Integer(param));
        return this;
    }

    public MessageBuilder append(long param) {
        this.params.add(new Long(param));
        return this;
    }

    public MessageBuilder append(Object[] params) {
        if (params != null) {
            this.params.addAll(Arrays.asList(params));
        }
        return this;
    }

    public String toString() {
        return this.getMessage();
    }

    protected String getMessage() {
        return StringUtil.getMessage(this.bundle, this.key, this.params.toArray());
    }
}

