/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.api.naming.pojo.healthcheck.impl;

import com.alibaba.nacos.api.naming.pojo.healthcheck.AbstractHealthChecker;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.base.Objects;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Http
extends AbstractHealthChecker {
    public static final String TYPE = "HTTP";
    private String path = "";
    private String headers = "";
    private int expectedResponseCode = 200;

    public Http() {
        super(TYPE);
    }

    public int getExpectedResponseCode() {
        return this.expectedResponseCode;
    }

    public void setExpectedResponseCode(int expectedResponseCode) {
        this.expectedResponseCode = expectedResponseCode;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getHeaders() {
        return this.headers;
    }

    public void setHeaders(String headers) {
        this.headers = headers;
    }

    @JsonIgnore
    public Map<String, String> getCustomHeaders() {
        if (StringUtils.isBlank((CharSequence)this.headers)) {
            return Collections.emptyMap();
        }
        HashMap<String, String> headerMap = new HashMap<String, String>(16);
        for (String s : this.headers.split("\\|")) {
            String[] splits = s.split(":");
            if (splits.length != 2) continue;
            headerMap.put(StringUtils.trim((String)splits[0]), StringUtils.trim((String)splits[1]));
        }
        return headerMap;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.path, this.headers, this.expectedResponseCode});
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Http)) {
            return false;
        }
        Http other = (Http)obj;
        if (!StringUtils.equals((CharSequence)this.type, (CharSequence)other.getType())) {
            return false;
        }
        if (!StringUtils.equals((CharSequence)this.path, (CharSequence)other.getPath())) {
            return false;
        }
        if (!StringUtils.equals((CharSequence)this.headers, (CharSequence)other.getHeaders())) {
            return false;
        }
        return this.expectedResponseCode == other.getExpectedResponseCode();
    }

    @Override
    public Http clone() throws CloneNotSupportedException {
        Http config = new Http();
        config.setPath(this.getPath());
        config.setHeaders(this.getHeaders());
        config.setExpectedResponseCode(this.getExpectedResponseCode());
        return config;
    }
}

