/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.spring.util;

import com.alibaba.nacos.spring.util.NacosUtils;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import org.springframework.beans.factory.BeanFactory;

public enum GlobalNacosPropertiesSource {
    DEFAULT("globalNacosProperties"),
    CONFIG("globalNacosProperties$config"),
    DISCOVERY("globalNacosProperties$discovery");

    private final String beanName;

    private GlobalNacosPropertiesSource(String beanName) {
        this.beanName = beanName;
    }

    public Properties getMergedGlobalProperties(BeanFactory beanFactory) {
        Properties currentProperties = this.getProperties(beanFactory, this.beanName);
        Properties globalProperties = this.getProperties(beanFactory, "globalNacosProperties");
        NacosUtils.merge(globalProperties, currentProperties);
        return globalProperties;
    }

    private Properties getProperties(BeanFactory beanFactory, String beanName) {
        Properties properties = new Properties();
        Map propertiesSource = beanFactory.containsBean(beanName) ? (Map)beanFactory.getBean(beanName, Properties.class) : Collections.emptyMap();
        properties.putAll((Map<?, ?>)propertiesSource);
        return properties;
    }
}

