/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.client;

import com.alipay.sofa.rpc.bootstrap.ConsumerBootstrap;
import com.alipay.sofa.rpc.client.AddressHolder;
import com.alipay.sofa.rpc.common.utils.ExceptionUtils;
import com.alipay.sofa.rpc.core.exception.SofaRpcRuntimeException;
import com.alipay.sofa.rpc.ext.ExtensionClass;
import com.alipay.sofa.rpc.ext.ExtensionLoaderFactory;

public class AddressHolderFactory {
    public static AddressHolder getAddressHolder(ConsumerBootstrap consumerBootstrap) {
        try {
            String connectionHolder = consumerBootstrap.getConsumerConfig().getAddressHolder();
            ExtensionClass<AddressHolder> ext = ExtensionLoaderFactory.getExtensionLoader(AddressHolder.class).getExtensionClass(connectionHolder);
            if (ext == null) {
                throw ExceptionUtils.buildRuntime("consumer.addressHolder", connectionHolder, "Unsupported addressHolder of client!");
            }
            return ext.getExtInstance(new Class[]{ConsumerBootstrap.class}, new Object[]{consumerBootstrap});
        }
        catch (SofaRpcRuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new SofaRpcRuntimeException(e.getMessage(), e);
        }
    }
}

