/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.server;

import com.alipay.sofa.rpc.common.RpcConfigs;
import com.alipay.sofa.rpc.common.SystemInfo;
import com.alipay.sofa.rpc.common.utils.CommonUtils;
import com.alipay.sofa.rpc.common.utils.ExceptionUtils;
import com.alipay.sofa.rpc.common.utils.NetUtils;
import com.alipay.sofa.rpc.common.utils.StringUtils;
import com.alipay.sofa.rpc.config.ServerConfig;
import com.alipay.sofa.rpc.core.exception.SofaRpcRuntimeException;
import com.alipay.sofa.rpc.ext.ExtensionClass;
import com.alipay.sofa.rpc.ext.ExtensionLoaderFactory;
import com.alipay.sofa.rpc.log.Logger;
import com.alipay.sofa.rpc.log.LoggerFactory;
import com.alipay.sofa.rpc.server.Server;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class ServerFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServerFactory.class);
    private static final ConcurrentMap<String, Server> SERVER_MAP = new ConcurrentHashMap<String, Server>();

    public static synchronized Server getServer(ServerConfig serverConfig) {
        try {
            Server server = (Server)SERVER_MAP.get(Integer.toString(serverConfig.getPort()));
            if (server == null) {
                ServerFactory.resolveServerConfig(serverConfig);
                ExtensionClass<Server> ext = ExtensionLoaderFactory.getExtensionLoader(Server.class).getExtensionClass(serverConfig.getProtocol());
                if (ext == null) {
                    throw ExceptionUtils.buildRuntime("server.protocol", serverConfig.getProtocol(), "Unsupported protocol of server!");
                }
                server = ext.getExtInstance();
                server.init(serverConfig);
                SERVER_MAP.put(serverConfig.getPort() + "", server);
            }
            return server;
        }
        catch (SofaRpcRuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new SofaRpcRuntimeException(e.getMessage(), e);
        }
    }

    private static void resolveServerConfig(ServerConfig serverConfig) {
        int oriPort;
        int port;
        String boundHost = serverConfig.getBoundHost();
        if (boundHost == null) {
            String host = serverConfig.getHost();
            if (StringUtils.isBlank(host)) {
                host = SystemInfo.getLocalHost();
                serverConfig.setHost(host);
                boundHost = SystemInfo.isWindows() ? host : "0.0.0.0";
            } else {
                boundHost = host;
            }
            serverConfig.setBoundHost(boundHost);
        }
        if (serverConfig.isAdaptivePort() && (port = NetUtils.getAvailablePort(boundHost, oriPort = serverConfig.getPort(), RpcConfigs.getIntValue("server.port.end"))) != oriPort) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Changed port from {} to {} because the config port is disabled", oriPort, port);
            }
            serverConfig.setPort(port);
        }
    }

    public static List<Server> getServers() {
        return new ArrayList<Server>(SERVER_MAP.values());
    }

    public static void destroyAll() {
        if (CommonUtils.isEmpty(SERVER_MAP)) {
            return;
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Destroy all server now!");
        }
        for (Map.Entry entry : SERVER_MAP.entrySet()) {
            String key = (String)entry.getKey();
            Server server = (Server)entry.getValue();
            try {
                server.destroy();
            }
            catch (Exception e) {
                LOGGER.error("Error when destroy server with key:" + key, e);
            }
        }
        SERVER_MAP.clear();
    }

    public static void destroyServer(ServerConfig serverConfig) {
        try {
            Server server = serverConfig.getServer();
            if (server != null) {
                serverConfig.setServer(null);
                SERVER_MAP.remove(Integer.toString(serverConfig.getPort()));
                server.destroy();
            }
        }
        catch (Exception e) {
            LOGGER.error("Error when destroy server with key:" + serverConfig.getPort(), e);
        }
    }
}

