/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.buffer;

import com.aliyun.openservices.shade.io.netty.buffer.AbstractDerivedByteBuf;
import com.aliyun.openservices.shade.io.netty.buffer.ByteBuf;
import com.aliyun.openservices.shade.io.netty.buffer.ByteBufAllocator;
import com.aliyun.openservices.shade.io.netty.buffer.ByteBufProcessor;
import com.aliyun.openservices.shade.io.netty.buffer.DuplicatedByteBuf;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;

public class SlicedByteBuf
extends AbstractDerivedByteBuf {
    private final ByteBuf buffer;
    private final int adjustment;
    private final int length;

    public SlicedByteBuf(ByteBuf buffer, int index, int length) {
        super(length);
        if (index < 0 || index > buffer.capacity() - length) {
            throw new IndexOutOfBoundsException(buffer + ".slice(" + index + ", " + length + ')');
        }
        if (buffer instanceof SlicedByteBuf) {
            this.buffer = ((SlicedByteBuf)buffer).buffer;
            this.adjustment = ((SlicedByteBuf)buffer).adjustment + index;
        } else if (buffer instanceof DuplicatedByteBuf) {
            this.buffer = buffer.unwrap();
            this.adjustment = index;
        } else {
            this.buffer = buffer;
            this.adjustment = index;
        }
        this.length = length;
        this.writerIndex(length);
    }

    @Override
    public ByteBuf unwrap() {
        return this.buffer;
    }

    @Override
    public ByteBufAllocator alloc() {
        return this.buffer.alloc();
    }

    @Override
    public ByteOrder order() {
        return this.buffer.order();
    }

    @Override
    public boolean isDirect() {
        return this.buffer.isDirect();
    }

    @Override
    public int capacity() {
        return this.length;
    }

    @Override
    public ByteBuf capacity(int newCapacity) {
        throw new UnsupportedOperationException("sliced buffer");
    }

    @Override
    public boolean hasArray() {
        return this.buffer.hasArray();
    }

    @Override
    public byte[] array() {
        return this.buffer.array();
    }

    @Override
    public int arrayOffset() {
        return this.idx(this.buffer.arrayOffset());
    }

    @Override
    public boolean hasMemoryAddress() {
        return this.buffer.hasMemoryAddress();
    }

    @Override
    public long memoryAddress() {
        return this.buffer.memoryAddress() + (long)this.adjustment;
    }

    @Override
    protected byte _getByte(int index) {
        return this.buffer.getByte(this.idx(index));
    }

    @Override
    protected short _getShort(int index) {
        return this.buffer.getShort(this.idx(index));
    }

    @Override
    protected int _getUnsignedMedium(int index) {
        return this.buffer.getUnsignedMedium(this.idx(index));
    }

    @Override
    protected int _getInt(int index) {
        return this.buffer.getInt(this.idx(index));
    }

    @Override
    protected long _getLong(int index) {
        return this.buffer.getLong(this.idx(index));
    }

    @Override
    public ByteBuf duplicate() {
        ByteBuf duplicate = this.buffer.slice(this.adjustment, this.length);
        duplicate.setIndex(this.readerIndex(), this.writerIndex());
        return duplicate;
    }

    @Override
    public ByteBuf copy(int index, int length) {
        this.checkIndex0(index, length);
        return this.buffer.copy(this.idx(index), length);
    }

    @Override
    public ByteBuf slice(int index, int length) {
        this.checkIndex0(index, length);
        return this.buffer.slice(this.idx(index), length);
    }

    @Override
    public ByteBuf getBytes(int index, ByteBuf dst, int dstIndex, int length) {
        this.checkIndex0(index, length);
        this.buffer.getBytes(this.idx(index), dst, dstIndex, length);
        return this;
    }

    @Override
    public ByteBuf getBytes(int index, byte[] dst, int dstIndex, int length) {
        this.checkIndex0(index, length);
        this.buffer.getBytes(this.idx(index), dst, dstIndex, length);
        return this;
    }

    @Override
    public ByteBuf getBytes(int index, ByteBuffer dst) {
        this.checkIndex0(index, dst.remaining());
        this.buffer.getBytes(this.idx(index), dst);
        return this;
    }

    @Override
    protected void _setByte(int index, int value) {
        this.buffer.setByte(this.idx(index), value);
    }

    @Override
    protected void _setShort(int index, int value) {
        this.buffer.setShort(this.idx(index), value);
    }

    @Override
    protected void _setMedium(int index, int value) {
        this.buffer.setMedium(this.idx(index), value);
    }

    @Override
    protected void _setInt(int index, int value) {
        this.buffer.setInt(this.idx(index), value);
    }

    @Override
    protected void _setLong(int index, long value) {
        this.buffer.setLong(this.idx(index), value);
    }

    @Override
    public ByteBuf setBytes(int index, byte[] src, int srcIndex, int length) {
        this.checkIndex0(index, length);
        this.buffer.setBytes(this.idx(index), src, srcIndex, length);
        return this;
    }

    @Override
    public ByteBuf setBytes(int index, ByteBuf src, int srcIndex, int length) {
        this.checkIndex0(index, length);
        this.buffer.setBytes(this.idx(index), src, srcIndex, length);
        return this;
    }

    @Override
    public ByteBuf setBytes(int index, ByteBuffer src) {
        this.checkIndex0(index, src.remaining());
        this.buffer.setBytes(this.idx(index), src);
        return this;
    }

    @Override
    public ByteBuf getBytes(int index, OutputStream out, int length) throws IOException {
        this.checkIndex0(index, length);
        this.buffer.getBytes(this.idx(index), out, length);
        return this;
    }

    @Override
    public int getBytes(int index, GatheringByteChannel out, int length) throws IOException {
        this.checkIndex0(index, length);
        return this.buffer.getBytes(this.idx(index), out, length);
    }

    @Override
    public int setBytes(int index, InputStream in, int length) throws IOException {
        this.checkIndex0(index, length);
        return this.buffer.setBytes(this.idx(index), in, length);
    }

    @Override
    public int setBytes(int index, ScatteringByteChannel in, int length) throws IOException {
        this.checkIndex0(index, length);
        return this.buffer.setBytes(this.idx(index), in, length);
    }

    @Override
    public int nioBufferCount() {
        return this.buffer.nioBufferCount();
    }

    @Override
    public ByteBuffer nioBuffer(int index, int length) {
        this.checkIndex0(index, length);
        return this.buffer.nioBuffer(this.idx(index), length);
    }

    @Override
    public ByteBuffer[] nioBuffers(int index, int length) {
        this.checkIndex0(index, length);
        return this.buffer.nioBuffers(this.idx(index), length);
    }

    @Override
    public ByteBuffer internalNioBuffer(int index, int length) {
        return this.nioBuffer(index, length);
    }

    @Override
    public int forEachByte(int index, int length, ByteBufProcessor processor) {
        this.checkIndex0(index, length);
        int ret = this.buffer.forEachByte(this.idx(index), length, processor);
        if (ret >= this.adjustment) {
            return ret - this.adjustment;
        }
        return -1;
    }

    @Override
    public int forEachByteDesc(int index, int length, ByteBufProcessor processor) {
        this.checkIndex0(index, length);
        int ret = this.buffer.forEachByteDesc(this.idx(index), length, processor);
        if (ret >= this.adjustment) {
            return ret - this.adjustment;
        }
        return -1;
    }

    final int idx(int index) {
        return index + this.adjustment;
    }
}

