/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.dts.parser;

import com.baomidou.mybatisplus.dts.parser.IDtsParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.springframework.stereotype.Component;

@Component
public class JacksonDtsParser
implements IDtsParser {
    private static ObjectMapper objectMapper;

    public static ObjectMapper getObjectMapper() {
        if (objectMapper == null) {
            objectMapper = new ObjectMapper();
            objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        }
        return objectMapper;
    }

    @Override
    public <T> T readValue(String jsonStr, Class<T> valueType) throws Exception {
        if (null == jsonStr || "".equals(jsonStr)) {
            return null;
        }
        return (T)JacksonDtsParser.getObjectMapper().readValue(jsonStr, valueType);
    }

    @Override
    public String toJSONString(Object object) throws Exception {
        return JacksonDtsParser.getObjectMapper().writeValueAsString(object);
    }
}

