/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.mapper;

import com.baomidou.mybatisplus.entity.GlobalConfiguration;
import com.baomidou.mybatisplus.entity.TableFieldInfo;
import com.baomidou.mybatisplus.entity.TableInfo;
import com.baomidou.mybatisplus.enums.FieldFill;
import com.baomidou.mybatisplus.enums.FieldStrategy;
import com.baomidou.mybatisplus.enums.IdType;
import com.baomidou.mybatisplus.enums.SqlMethod;
import com.baomidou.mybatisplus.mapper.BaseMapper;
import com.baomidou.mybatisplus.mapper.ISqlInjector;
import com.baomidou.mybatisplus.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.toolkit.GlobalConfigUtils;
import com.baomidou.mybatisplus.toolkit.SqlReservedWords;
import com.baomidou.mybatisplus.toolkit.StringUtils;
import com.baomidou.mybatisplus.toolkit.TableInfoHelper;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.ibatis.builder.MapperBuilderAssistant;
import org.apache.ibatis.executor.keygen.Jdbc3KeyGenerator;
import org.apache.ibatis.executor.keygen.KeyGenerator;
import org.apache.ibatis.executor.keygen.NoKeyGenerator;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ResultMap;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.mapping.StatementType;
import org.apache.ibatis.scripting.LanguageDriver;
import org.apache.ibatis.scripting.defaults.RawSqlSource;
import org.apache.ibatis.session.Configuration;

public class AutoSqlInjector
implements ISqlInjector {
    private static final Log logger = LogFactory.getLog(AutoSqlInjector.class);
    protected Configuration configuration;
    protected LanguageDriver languageDriver;
    protected MapperBuilderAssistant builderAssistant;

    @Override
    public void inspectInject(MapperBuilderAssistant builderAssistant, Class<?> mapperClass) {
        String className = mapperClass.toString();
        Set<String> mapperRegistryCache = GlobalConfigUtils.getMapperRegistryCache(builderAssistant.getConfiguration());
        if (!mapperRegistryCache.contains(className)) {
            this.inject(builderAssistant, mapperClass);
            mapperRegistryCache.add(className);
        }
    }

    @Override
    public void inject(MapperBuilderAssistant builderAssistant, Class<?> mapperClass) {
        Class<?> modelClass;
        this.configuration = builderAssistant.getConfiguration();
        this.builderAssistant = builderAssistant;
        this.languageDriver = this.configuration.getDefaultScriptingLanguageInstance();
        GlobalConfiguration globalCache = this.getGlobalConfig();
        if (!globalCache.isDbColumnUnderline()) {
            globalCache.setDbColumnUnderline(this.configuration.isMapUnderscoreToCamelCase());
        }
        if ((modelClass = this.extractModelClass(mapperClass)) != null) {
            TableInfo table = TableInfoHelper.initTableInfo(builderAssistant, modelClass);
            this.injectSql(builderAssistant, mapperClass, modelClass, table);
        }
    }

    protected void injectSql(MapperBuilderAssistant builderAssistant, Class<?> mapperClass, Class<?> modelClass, TableInfo table) {
        if (StringUtils.isNotEmpty(table.getKeyProperty())) {
            this.injectDeleteByIdSql(false, mapperClass, modelClass, table);
            this.injectDeleteByIdSql(true, mapperClass, modelClass, table);
            this.injectUpdateByIdSql(true, mapperClass, modelClass, table);
            this.injectUpdateByIdSql(false, mapperClass, modelClass, table);
            this.injectSelectByIdSql(false, mapperClass, modelClass, table);
            this.injectSelectByIdSql(true, mapperClass, modelClass, table);
        } else {
            logger.warn(String.format("%s ,Not found @TableId annotation, Cannot use Mybatis-Plus 'xxById' Method.", modelClass.toString()));
        }
        this.injectInsertOneSql(true, mapperClass, modelClass, table);
        this.injectInsertOneSql(false, mapperClass, modelClass, table);
        this.injectDeleteSql(mapperClass, modelClass, table);
        this.injectDeleteByMapSql(mapperClass, table);
        this.injectUpdateSql(mapperClass, modelClass, table);
        this.injectSelectByMapSql(mapperClass, modelClass, table);
        this.injectSelectOneSql(mapperClass, modelClass, table);
        this.injectSelectCountSql(mapperClass, modelClass, table);
        this.injectSelectListSql(SqlMethod.SELECT_LIST, mapperClass, modelClass, table);
        this.injectSelectListSql(SqlMethod.SELECT_PAGE, mapperClass, modelClass, table);
        this.injectSelectMapsSql(SqlMethod.SELECT_MAPS, mapperClass, modelClass, table);
        this.injectSelectMapsSql(SqlMethod.SELECT_MAPS_PAGE, mapperClass, modelClass, table);
        this.injectSelectObjsSql(SqlMethod.SELECT_OBJS, mapperClass, modelClass, table);
        this.inject(this.configuration, builderAssistant, mapperClass, modelClass, table);
    }

    public void inject(Configuration configuration, MapperBuilderAssistant builderAssistant, Class<?> mapperClass, Class<?> modelClass, TableInfo table) {
    }

    protected Class<?> extractModelClass(Class<?> mapperClass) {
        if (mapperClass == BaseMapper.class) {
            logger.warn(" Current Class is BaseMapper ");
            return null;
        }
        Type[] types = mapperClass.getGenericInterfaces();
        ParameterizedType target = null;
        for (Type type : types) {
            if (!(type instanceof ParameterizedType) || !BaseMapper.class.isAssignableFrom(mapperClass)) continue;
            target = (ParameterizedType)type;
            break;
        }
        return target == null ? null : (Class)target.getActualTypeArguments()[0];
    }

    protected void injectInsertOneSql(boolean selective, Class<?> mapperClass, Class<?> modelClass, TableInfo table) {
        NoKeyGenerator keyGenerator = new NoKeyGenerator();
        StringBuilder fieldBuilder = new StringBuilder();
        StringBuilder placeholderBuilder = new StringBuilder();
        SqlMethod sqlMethod = selective ? SqlMethod.INSERT_ONE : SqlMethod.INSERT_ONE_ALL_COLUMN;
        fieldBuilder.append("\n<trim prefix=\"(\" suffix=\")\" suffixOverrides=\",\">\n");
        placeholderBuilder.append("\n<trim prefix=\"(\" suffix=\")\" suffixOverrides=\",\">\n");
        String keyProperty = null;
        String keyColumn = null;
        if (StringUtils.isNotEmpty(table.getKeyProperty())) {
            if (table.getIdType() == IdType.AUTO) {
                keyGenerator = new Jdbc3KeyGenerator();
                keyProperty = table.getKeyProperty();
                keyColumn = table.getKeyColumn();
            } else if (null != table.getKeySequence()) {
                keyGenerator = TableInfoHelper.genKeyGenerator(table, this.builderAssistant, sqlMethod.getMethod(), this.languageDriver);
                keyProperty = table.getKeyProperty();
                keyColumn = table.getKeyColumn();
                fieldBuilder.append(table.getKeyColumn()).append(",");
                placeholderBuilder.append("#{").append(table.getKeyProperty()).append("},");
            } else {
                fieldBuilder.append(table.getKeyColumn()).append(",");
                placeholderBuilder.append("#{").append(table.getKeyProperty()).append("},");
            }
        }
        List<TableFieldInfo> fieldList = table.getFieldList();
        for (TableFieldInfo fieldInfo : fieldList) {
            boolean ifTag;
            boolean bl = ifTag = FieldFill.INSERT != fieldInfo.getFieldFill() && FieldFill.INSERT_UPDATE != fieldInfo.getFieldFill();
            if (selective && ifTag) {
                fieldBuilder.append(this.convertIfTagIgnored(fieldInfo, false));
                fieldBuilder.append(fieldInfo.getColumn()).append(",");
                fieldBuilder.append(this.convertIfTagIgnored(fieldInfo, true));
                placeholderBuilder.append(this.convertIfTagIgnored(fieldInfo, false));
                placeholderBuilder.append("#{").append(fieldInfo.getEl()).append("},");
                placeholderBuilder.append(this.convertIfTagIgnored(fieldInfo, true));
                continue;
            }
            fieldBuilder.append(fieldInfo.getColumn()).append(",");
            placeholderBuilder.append("#{").append(fieldInfo.getEl()).append("},");
        }
        fieldBuilder.append("\n</trim>");
        placeholderBuilder.append("\n</trim>");
        String sql = String.format(sqlMethod.getSql(), table.getTableName(), fieldBuilder.toString(), placeholderBuilder.toString());
        SqlSource sqlSource = this.languageDriver.createSqlSource(this.configuration, sql, modelClass);
        this.addInsertMappedStatement(mapperClass, modelClass, sqlMethod.getMethod(), sqlSource, (KeyGenerator)keyGenerator, keyProperty, keyColumn);
    }

    protected void injectDeleteSql(Class<?> mapperClass, Class<?> modelClass, TableInfo table) {
        SqlMethod sqlMethod = SqlMethod.DELETE;
        String sql = String.format(sqlMethod.getSql(), table.getTableName(), this.sqlWhereEntityWrapper(table));
        SqlSource sqlSource = this.languageDriver.createSqlSource(this.configuration, sql, modelClass);
        this.addDeleteMappedStatement(mapperClass, sqlMethod.getMethod(), sqlSource);
    }

    protected void injectDeleteByMapSql(Class<?> mapperClass, TableInfo table) {
        SqlMethod sqlMethod = SqlMethod.DELETE_BY_MAP;
        String sql = String.format(sqlMethod.getSql(), table.getTableName(), this.sqlWhereByMap(table));
        SqlSource sqlSource = this.languageDriver.createSqlSource(this.configuration, sql, Map.class);
        this.addDeleteMappedStatement(mapperClass, sqlMethod.getMethod(), sqlSource);
    }

    protected void injectDeleteByIdSql(boolean batch, Class<?> mapperClass, Class<?> modelClass, TableInfo table) {
        SqlMethod sqlMethod = SqlMethod.DELETE_BY_ID;
        String idStr = table.getKeyProperty();
        if (batch) {
            sqlMethod = SqlMethod.DELETE_BATCH_BY_IDS;
            StringBuilder ids = new StringBuilder();
            ids.append("\n<foreach item=\"item\" index=\"index\" collection=\"list\" separator=\",\">");
            ids.append("#{item}");
            ids.append("\n</foreach>");
            idStr = ids.toString();
        }
        String sql = String.format(sqlMethod.getSql(), table.getTableName(), table.getKeyColumn(), idStr);
        SqlSource sqlSource = this.languageDriver.createSqlSource(this.configuration, sql, modelClass);
        this.addDeleteMappedStatement(mapperClass, sqlMethod.getMethod(), sqlSource);
    }

    protected void injectUpdateByIdSql(boolean selective, Class<?> mapperClass, Class<?> modelClass, TableInfo table) {
        SqlMethod sqlMethod = selective ? SqlMethod.UPDATE_BY_ID : SqlMethod.UPDATE_ALL_COLUMN_BY_ID;
        String sql = String.format(sqlMethod.getSql(), table.getTableName(), this.sqlSet(selective, table, "et."), table.getKeyColumn(), "et." + table.getKeyProperty(), "<if test=\"et instanceof java.util.Map\"><if test=\"et.MP_OPTLOCK_VERSION_ORIGINAL!=null\">and ${et.MP_OPTLOCK_VERSION_COLUMN}=#{et.MP_OPTLOCK_VERSION_ORIGINAL}</if></if>");
        SqlSource sqlSource = this.languageDriver.createSqlSource(this.configuration, sql, modelClass);
        this.addUpdateMappedStatement(mapperClass, modelClass, sqlMethod.getMethod(), sqlSource);
    }

    protected void injectUpdateSql(Class<?> mapperClass, Class<?> modelClass, TableInfo table) {
        SqlMethod sqlMethod = SqlMethod.UPDATE;
        String sql = String.format(sqlMethod.getSql(), table.getTableName(), this.sqlSet(true, table, "et."), this.sqlWhereEntityWrapper(table));
        SqlSource sqlSource = this.languageDriver.createSqlSource(this.configuration, sql, modelClass);
        this.addUpdateMappedStatement(mapperClass, modelClass, sqlMethod.getMethod(), sqlSource);
    }

    protected void injectSelectByIdSql(boolean batch, Class<?> mapperClass, Class<?> modelClass, TableInfo table) {
        RawSqlSource sqlSource;
        SqlMethod sqlMethod = SqlMethod.SELECT_BY_ID;
        if (batch) {
            sqlMethod = SqlMethod.SELECT_BATCH_BY_IDS;
            StringBuilder ids = new StringBuilder();
            ids.append("\n<foreach item=\"item\" index=\"index\" collection=\"list\" separator=\",\">");
            ids.append("#{item}");
            ids.append("\n</foreach>");
            sqlSource = this.languageDriver.createSqlSource(this.configuration, String.format(sqlMethod.getSql(), this.sqlSelectColumns(table, false), table.getTableName(), table.getKeyColumn(), ids.toString()), modelClass);
        } else {
            sqlSource = new RawSqlSource(this.configuration, String.format(sqlMethod.getSql(), this.sqlSelectColumns(table, false), table.getTableName(), table.getKeyColumn(), table.getKeyProperty()), Object.class);
        }
        this.addSelectMappedStatement(mapperClass, sqlMethod.getMethod(), (SqlSource)sqlSource, modelClass, table);
    }

    protected void injectSelectByMapSql(Class<?> mapperClass, Class<?> modelClass, TableInfo table) {
        SqlMethod sqlMethod = SqlMethod.SELECT_BY_MAP;
        String sql = String.format(sqlMethod.getSql(), this.sqlSelectColumns(table, false), table.getTableName(), this.sqlWhereByMap(table));
        SqlSource sqlSource = this.languageDriver.createSqlSource(this.configuration, sql, Map.class);
        this.addSelectMappedStatement(mapperClass, sqlMethod.getMethod(), sqlSource, modelClass, table);
    }

    protected void injectSelectOneSql(Class<?> mapperClass, Class<?> modelClass, TableInfo table) {
        SqlMethod sqlMethod = SqlMethod.SELECT_ONE;
        String sql = String.format(sqlMethod.getSql(), this.sqlSelectColumns(table, false), table.getTableName(), this.sqlWhere(table));
        SqlSource sqlSource = this.languageDriver.createSqlSource(this.configuration, sql, modelClass);
        this.addSelectMappedStatement(mapperClass, sqlMethod.getMethod(), sqlSource, modelClass, table);
    }

    protected void injectSelectListSql(SqlMethod sqlMethod, Class<?> mapperClass, Class<?> modelClass, TableInfo table) {
        String sql = String.format(sqlMethod.getSql(), this.sqlSelectColumns(table, true), table.getTableName(), this.sqlWhereEntityWrapper(table));
        SqlSource sqlSource = this.languageDriver.createSqlSource(this.configuration, sql, modelClass);
        this.addSelectMappedStatement(mapperClass, sqlMethod.getMethod(), sqlSource, modelClass, table);
    }

    protected void injectSelectMapsSql(SqlMethod sqlMethod, Class<?> mapperClass, Class<?> modelClass, TableInfo table) {
        String sql = String.format(sqlMethod.getSql(), this.sqlSelectColumns(table, true), table.getTableName(), this.sqlWhereEntityWrapper(table));
        SqlSource sqlSource = this.languageDriver.createSqlSource(this.configuration, sql, modelClass);
        this.addSelectMappedStatement(mapperClass, sqlMethod.getMethod(), sqlSource, Map.class, table);
    }

    protected void injectSelectObjsSql(SqlMethod sqlMethod, Class<?> mapperClass, Class<?> modelClass, TableInfo table) {
        String sql = String.format(sqlMethod.getSql(), this.sqlSelectObjsColumns(table), table.getTableName(), this.sqlWhereEntityWrapper(table));
        SqlSource sqlSource = this.languageDriver.createSqlSource(this.configuration, sql, modelClass);
        this.addSelectMappedStatement(mapperClass, sqlMethod.getMethod(), sqlSource, Object.class, table);
    }

    protected void injectSelectCountSql(Class<?> mapperClass, Class<?> modelClass, TableInfo table) {
        SqlMethod sqlMethod = SqlMethod.SELECT_COUNT;
        String sql = String.format(sqlMethod.getSql(), table.getTableName(), this.sqlWhereEntityWrapper(table));
        SqlSource sqlSource = this.languageDriver.createSqlSource(this.configuration, sql, modelClass);
        this.addSelectMappedStatement(mapperClass, sqlMethod.getMethod(), sqlSource, Integer.class, null);
    }

    protected String sqlWhereEntityWrapper(TableInfo table) {
        StringBuilder where = new StringBuilder(128);
        where.append("\n<where>");
        where.append("\n<if test=\"ew!=null\">");
        where.append("\n<if test=\"ew.entity!=null\">");
        if (StringUtils.isNotEmpty(table.getKeyProperty())) {
            where.append("\n<if test=\"ew.entity.").append(table.getKeyProperty()).append("!=null\">\n");
            where.append(table.getKeyColumn()).append("=#{ew.entity.").append(table.getKeyProperty()).append("}");
            where.append("\n</if>");
        }
        List<TableFieldInfo> fieldList = table.getFieldList();
        for (TableFieldInfo fieldInfo : fieldList) {
            where.append(this.convertIfTag(fieldInfo, "ew.entity.", false));
            where.append(" AND ").append(fieldInfo.getColumn()).append("=#{ew.entity.").append(fieldInfo.getEl()).append("}");
            where.append(this.convertIfTag(fieldInfo, true));
        }
        where.append("\n</if>");
        where.append("\n<if test=\"ew!=null and ew.sqlSegment!=null and ew.notEmptyOfWhere\">\n${ew.sqlSegment}\n</if>");
        where.append("\n</if>");
        where.append("\n</where>");
        where.append("\n<if test=\"ew!=null and ew.sqlSegment!=null and ew.emptyOfWhere\">\n${ew.sqlSegment}\n</if>");
        return where.toString();
    }

    protected String sqlSet(boolean selective, TableInfo table, String prefix) {
        StringBuilder set = new StringBuilder();
        set.append("<trim prefix=\"SET\" suffixOverrides=\",\">");
        List<TableFieldInfo> fieldList = table.getFieldList();
        for (TableFieldInfo fieldInfo : fieldList) {
            boolean ifTag;
            boolean bl = ifTag = FieldFill.UPDATE != fieldInfo.getFieldFill() && FieldFill.INSERT_UPDATE != fieldInfo.getFieldFill();
            if (selective && ifTag) {
                set.append(this.convertIfTag(true, fieldInfo, prefix, false));
                set.append(fieldInfo.getColumn()).append("=#{");
                if (null != prefix) {
                    set.append(prefix);
                }
                set.append(fieldInfo.getEl()).append("},");
                set.append(this.convertIfTag(true, fieldInfo, null, true));
                continue;
            }
            if (FieldFill.INSERT == fieldInfo.getFieldFill()) continue;
            set.append(fieldInfo.getColumn()).append("=#{");
            if (null != prefix) {
                set.append(prefix);
            }
            set.append(fieldInfo.getEl()).append("},");
        }
        set.append("\n</trim>");
        return set.toString();
    }

    protected String sqlWordConvert(String convertStr) {
        GlobalConfiguration globalConfig = GlobalConfigUtils.getGlobalConfig(this.configuration);
        return SqlReservedWords.convert(globalConfig, convertStr);
    }

    protected String sqlSelectColumns(TableInfo table, boolean entityWrapper) {
        StringBuilder columns = new StringBuilder();
        if (null != table.getResultMap()) {
            if (entityWrapper) {
                columns.append("<choose><when test=\"ew != null and ew.sqlSelect != null\">${ew.sqlSelect}</when><otherwise>");
            }
            columns.append("*");
            if (entityWrapper) {
                columns.append("</otherwise></choose>");
            }
        } else {
            if (entityWrapper) {
                columns.append("<choose><when test=\"ew != null and ew.sqlSelect != null\">${ew.sqlSelect}</when><otherwise>");
            }
            List<TableFieldInfo> fieldList = table.getFieldList();
            int size = 0;
            if (null != fieldList) {
                size = fieldList.size();
            }
            if (StringUtils.isNotEmpty(table.getKeyProperty())) {
                if (table.isKeyRelated()) {
                    columns.append(table.getKeyColumn()).append(" AS ").append(this.sqlWordConvert(table.getKeyProperty()));
                } else {
                    columns.append(this.sqlWordConvert(table.getKeyProperty()));
                }
                if (size >= 1) {
                    columns.append(",");
                }
            }
            if (size >= 1) {
                int i = 0;
                for (TableFieldInfo fieldInfo : fieldList) {
                    String wordConvert = this.sqlWordConvert(fieldInfo.getProperty());
                    if (fieldInfo.getColumn().equals(wordConvert)) {
                        columns.append(wordConvert);
                    } else {
                        columns.append(fieldInfo.getColumn());
                        columns.append(" AS ").append(wordConvert);
                    }
                    if (i + 1 < size) {
                        columns.append(",");
                    }
                    ++i;
                }
            }
            if (entityWrapper) {
                columns.append("</otherwise></choose>");
            }
        }
        return columns.toString();
    }

    protected String sqlSelectObjsColumns(TableInfo table) {
        StringBuilder columns = new StringBuilder();
        columns.append("<choose><when test=\"ew != null and ew.sqlSelect != null\">${ew.sqlSelect}</when><otherwise>");
        if (StringUtils.isNotEmpty(table.getKeyProperty())) {
            if (table.isKeyRelated()) {
                columns.append(table.getKeyColumn()).append(" AS ").append(this.sqlWordConvert(table.getKeyProperty()));
            } else {
                columns.append(this.sqlWordConvert(table.getKeyProperty()));
            }
        } else {
            List<TableFieldInfo> fieldList = table.getFieldList();
            if (CollectionUtils.isNotEmpty(fieldList)) {
                TableFieldInfo fieldInfo = fieldList.get(0);
                String wordConvert = this.sqlWordConvert(fieldInfo.getProperty());
                if (fieldInfo.getColumn().equals(wordConvert)) {
                    columns.append(wordConvert);
                } else {
                    columns.append(fieldInfo.getColumn());
                    columns.append(" AS ").append(wordConvert);
                }
            }
        }
        columns.append("</otherwise></choose>");
        return columns.toString();
    }

    protected String sqlWhere(TableInfo table) {
        StringBuilder where = new StringBuilder();
        where.append("\n<where>");
        if (StringUtils.isNotEmpty(table.getKeyProperty())) {
            where.append("\n<if test=\"ew.").append(table.getKeyProperty()).append("!=null\">\n");
            where.append(table.getKeyColumn()).append("=#{ew.").append(table.getKeyProperty()).append("}");
            where.append("\n</if>");
        }
        List<TableFieldInfo> fieldList = table.getFieldList();
        for (TableFieldInfo fieldInfo : fieldList) {
            where.append(this.convertIfTag(fieldInfo, "ew.", false));
            where.append(" AND ").append(fieldInfo.getColumn()).append("=#{ew.").append(fieldInfo.getEl()).append("}");
            where.append(this.convertIfTag(fieldInfo, true));
        }
        where.append("\n</where>");
        return where.toString();
    }

    protected String sqlWhereByMap(TableInfo table) {
        StringBuilder where = new StringBuilder();
        where.append("\n<if test=\"cm!=null and !cm.isEmpty\">");
        where.append("\n<where>");
        where.append("\n<foreach collection=\"cm.keys\" item=\"k\" separator=\"AND\">");
        where.append("\n<if test=\"cm[k] != null\">");
        where.append(SqlReservedWords.convert(this.getGlobalConfig(), "\n${k}")).append(" = #{cm[${k}]}");
        where.append("\n</if>");
        where.append("\n</foreach>");
        where.append("\n</where>");
        where.append("\n</if>");
        return where.toString();
    }

    protected String convertIfTag(boolean ignored, TableFieldInfo fieldInfo, String prefix, boolean close) {
        FieldStrategy fieldStrategy = fieldInfo.getFieldStrategy();
        if (fieldStrategy == FieldStrategy.IGNORED) {
            if (ignored) {
                return "";
            }
            fieldStrategy = this.getGlobalConfig().getFieldStrategy();
        }
        if (close) {
            return "</if>";
        }
        String property = fieldInfo.getProperty();
        Class<?> propertyType = fieldInfo.getPropertyType();
        property = StringUtils.removeIsPrefixIfBoolean(property, propertyType);
        if (null != prefix) {
            property = prefix + property;
        }
        if (fieldStrategy == FieldStrategy.NOT_EMPTY) {
            if (StringUtils.isCharSequence(propertyType).booleanValue()) {
                return String.format("\n\t<if test=\"%s!=null and %s!=''\">", property, property);
            }
            return String.format("\n\t<if test=\"%s!=null \">", property);
        }
        return String.format("\n\t<if test=\"%s!=null\">", property);
    }

    protected String convertIfTagIgnored(TableFieldInfo fieldInfo, boolean close) {
        return this.convertIfTag(true, fieldInfo, null, close);
    }

    protected String convertIfTag(TableFieldInfo fieldInfo, String prefix, boolean close) {
        return this.convertIfTag(false, fieldInfo, prefix, close);
    }

    protected String convertIfTag(TableFieldInfo fieldInfo, boolean close) {
        return this.convertIfTag(fieldInfo, null, close);
    }

    public MappedStatement addSelectMappedStatement(Class<?> mapperClass, String id, SqlSource sqlSource, Class<?> resultType, TableInfo table) {
        String resultMap;
        if (null != table && null != (resultMap = table.getResultMap())) {
            return this.addMappedStatement(mapperClass, id, sqlSource, SqlCommandType.SELECT, null, resultMap, null, (KeyGenerator)new NoKeyGenerator(), null, null);
        }
        return this.addMappedStatement(mapperClass, id, sqlSource, SqlCommandType.SELECT, null, null, resultType, (KeyGenerator)new NoKeyGenerator(), null, null);
    }

    public MappedStatement addInsertMappedStatement(Class<?> mapperClass, Class<?> modelClass, String id, SqlSource sqlSource, KeyGenerator keyGenerator, String keyProperty, String keyColumn) {
        return this.addMappedStatement(mapperClass, id, sqlSource, SqlCommandType.INSERT, modelClass, null, Integer.class, keyGenerator, keyProperty, keyColumn);
    }

    public MappedStatement addDeleteMappedStatement(Class<?> mapperClass, String id, SqlSource sqlSource) {
        return this.addMappedStatement(mapperClass, id, sqlSource, SqlCommandType.DELETE, null, null, Integer.class, (KeyGenerator)new NoKeyGenerator(), null, null);
    }

    public MappedStatement addUpdateMappedStatement(Class<?> mapperClass, Class<?> modelClass, String id, SqlSource sqlSource) {
        return this.addMappedStatement(mapperClass, id, sqlSource, SqlCommandType.UPDATE, modelClass, null, Integer.class, (KeyGenerator)new NoKeyGenerator(), null, null);
    }

    public MappedStatement addMappedStatement(Class<?> mapperClass, String id, SqlSource sqlSource, SqlCommandType sqlCommandType, Class<?> parameterClass, String resultMap, Class<?> resultType, KeyGenerator keyGenerator, String keyProperty, String keyColumn) {
        String statementName = mapperClass.getName() + "." + id;
        if (this.configuration.hasStatement(statementName)) {
            System.err.println("{" + statementName + "} Has been loaded by XML or SqlProvider, ignoring the injection of the SQL.");
            return null;
        }
        boolean isSelect = false;
        if (sqlCommandType == SqlCommandType.SELECT) {
            isSelect = true;
        }
        return this.builderAssistant.addMappedStatement(id, sqlSource, StatementType.PREPARED, sqlCommandType, null, null, null, parameterClass, resultMap, resultType, null, !isSelect, isSelect, false, keyGenerator, keyProperty, keyColumn, this.configuration.getDatabaseId(), this.languageDriver, null);
    }

    @Override
    public void injectSqlRunner(Configuration configuration) {
        this.configuration = configuration;
        this.languageDriver = configuration.getDefaultScriptingLanguageInstance();
        this.initSelectList();
        this.initSelectObjs();
        this.initInsert();
        this.initUpdate();
        this.initDelete();
        this.initCount();
    }

    private boolean hasMappedStatement(String mappedStatement) {
        return this.configuration.hasStatement(mappedStatement, false);
    }

    private void createSelectMappedStatement(String mappedStatement, SqlSource sqlSource, final Class<?> resultType) {
        MappedStatement ms = new MappedStatement.Builder(this.configuration, mappedStatement, sqlSource, SqlCommandType.SELECT).resultMaps((List)new ArrayList<ResultMap>(){
            {
                this.add(new ResultMap.Builder(AutoSqlInjector.this.configuration, "defaultResultMap", resultType, new ArrayList(0)).build());
            }
        }).build();
        this.configuration.addMappedStatement(ms);
    }

    private void createUpdateMappedStatement(String mappedStatement, SqlSource sqlSource, SqlCommandType sqlCommandType) {
        MappedStatement ms = new MappedStatement.Builder(this.configuration, mappedStatement, sqlSource, sqlCommandType).resultMaps((List)new ArrayList<ResultMap>(){
            {
                this.add(new ResultMap.Builder(AutoSqlInjector.this.configuration, "defaultResultMap", Integer.TYPE, new ArrayList(0)).build());
            }
        }).build();
        this.configuration.addMappedStatement(ms);
    }

    private void initSelectList() {
        if (this.hasMappedStatement("com.baomidou.mybatisplus.mapper.SqlRunner.SelectList")) {
            logger.warn("MappedStatement 'SqlRunner.SelectList' Already Exists");
            return;
        }
        SqlSource sqlSource = this.languageDriver.createSqlSource(this.configuration, "${sql}", Map.class);
        this.createSelectMappedStatement("com.baomidou.mybatisplus.mapper.SqlRunner.SelectList", sqlSource, Map.class);
    }

    private void initSelectObjs() {
        if (this.hasMappedStatement("com.baomidou.mybatisplus.mapper.SqlRunner.SelectObjs")) {
            logger.warn("MappedStatement 'SqlRunner.SelectObjs' Already Exists");
            return;
        }
        SqlSource sqlSource = this.languageDriver.createSqlSource(this.configuration, "${sql}", Object.class);
        this.createSelectMappedStatement("com.baomidou.mybatisplus.mapper.SqlRunner.SelectObjs", sqlSource, Object.class);
    }

    private void initCount() {
        if (this.hasMappedStatement("com.baomidou.mybatisplus.mapper.SqlRunner.Count")) {
            logger.warn("MappedStatement 'SqlRunner.Count' Already Exists");
            return;
        }
        SqlSource sqlSource = this.languageDriver.createSqlSource(this.configuration, "${sql}", Map.class);
        this.createSelectMappedStatement("com.baomidou.mybatisplus.mapper.SqlRunner.Count", sqlSource, Integer.class);
    }

    private void initInsert() {
        if (this.hasMappedStatement("com.baomidou.mybatisplus.mapper.SqlRunner.Insert")) {
            logger.warn("MappedStatement 'SqlRunner.Insert' Already Exists");
            return;
        }
        SqlSource sqlSource = this.languageDriver.createSqlSource(this.configuration, "${sql}", Map.class);
        this.createUpdateMappedStatement("com.baomidou.mybatisplus.mapper.SqlRunner.Insert", sqlSource, SqlCommandType.INSERT);
    }

    private void initUpdate() {
        if (this.hasMappedStatement("com.baomidou.mybatisplus.mapper.SqlRunner.Update")) {
            logger.warn("MappedStatement 'SqlRunner.Update' Already Exists");
            return;
        }
        SqlSource sqlSource = this.languageDriver.createSqlSource(this.configuration, "${sql}", Map.class);
        this.createUpdateMappedStatement("com.baomidou.mybatisplus.mapper.SqlRunner.Update", sqlSource, SqlCommandType.UPDATE);
    }

    private void initDelete() {
        if (this.hasMappedStatement("com.baomidou.mybatisplus.mapper.SqlRunner.Delete")) {
            logger.warn("MappedStatement 'SqlRunner.Delete' Already Exists");
            return;
        }
        SqlSource sqlSource = this.languageDriver.createSqlSource(this.configuration, "${sql}", Map.class);
        this.createUpdateMappedStatement("com.baomidou.mybatisplus.mapper.SqlRunner.Delete", sqlSource, SqlCommandType.DELETE);
    }

    protected GlobalConfiguration getGlobalConfig() {
        return GlobalConfigUtils.getGlobalConfig(this.configuration);
    }
}

