/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.tx.netty.service.impl;

import com.codingapi.tx.Constants;
import com.codingapi.tx.framework.utils.SocketManager;
import com.codingapi.tx.netty.handler.TransactionHandler;
import com.codingapi.tx.netty.service.NettyControlService;
import com.codingapi.tx.netty.service.NettyDistributeService;
import com.codingapi.tx.netty.service.NettyService;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import io.netty.handler.codec.LengthFieldPrepender;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class NettyServiceImpl
implements NettyService,
DisposableBean {
    @Autowired
    private NettyDistributeService nettyDistributeService;
    @Autowired
    private NettyControlService nettyControlService;
    private EventLoopGroup workerGroup;
    private static volatile boolean isStarting = false;
    private Logger logger = LoggerFactory.getLogger(NettyServiceImpl.class);
    private ExecutorService threadPool = Executors.newFixedThreadPool(100);

    @Override
    public synchronized void start() {
        if (isStarting) {
            return;
        }
        isStarting = true;
        this.nettyDistributeService.loadTxServer();
        String host = Constants.txServer.getHost();
        int port = Constants.txServer.getPort();
        final int heart = Constants.txServer.getHeart();
        int delay = Constants.txServer.getDelay();
        final TransactionHandler transactionHandler = new TransactionHandler(this.threadPool, this.nettyControlService, delay);
        this.workerGroup = new NioEventLoopGroup();
        try {
            Bootstrap b = new Bootstrap();
            b.group(this.workerGroup);
            b.channel(NioSocketChannel.class);
            b.option(ChannelOption.SO_KEEPALIVE, (Object)true);
            b.handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                public void initChannel(SocketChannel ch) throws Exception {
                    ch.pipeline().addLast("timeout", (ChannelHandler)new IdleStateHandler((long)heart, (long)heart, (long)heart, TimeUnit.SECONDS));
                    ch.pipeline().addLast(new ChannelHandler[]{new LengthFieldPrepender(4, false)});
                    ch.pipeline().addLast(new ChannelHandler[]{new LengthFieldBasedFrameDecoder(Integer.MAX_VALUE, 0, 4, 0, 4)});
                    ch.pipeline().addLast(new ChannelHandler[]{transactionHandler});
                }
            });
            this.logger.info("connection txManager-socket-> host:" + host + ",port:" + port);
            ChannelFuture future = b.connect(host, port);
            future.addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture channelFuture) throws Exception {
                    if (!channelFuture.isSuccess()) {
                        channelFuture.channel().eventLoop().schedule(new Runnable(){

                            @Override
                            public void run() {
                                isStarting = false;
                                NettyServiceImpl.this.start();
                            }
                        }, 5L, TimeUnit.SECONDS);
                    }
                }
            });
        }
        catch (Exception e) {
            this.logger.error(e.getLocalizedMessage());
        }
    }

    @Override
    public synchronized void close() {
        if (this.workerGroup != null) {
            this.workerGroup.shutdownGracefully();
            this.workerGroup = null;
            SocketManager.getInstance().setNetState(false);
            isStarting = false;
        }
    }

    @Override
    public boolean checkState() {
        if (!SocketManager.getInstance().isNetState()) {
            this.logger.error("socket not connection wait 2 seconds.");
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (!SocketManager.getInstance().isNetState()) {
                this.logger.error("socket not connection,check txManager server .");
                return false;
            }
        }
        return true;
    }

    public void destroy() throws Exception {
        this.close();
        SocketManager.getInstance().close();
        this.threadPool.shutdown();
    }
}

