/*
 * Decompiled with CFR 0.152.
 */
package com.crygier.spring.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public class SystemPropertyPlaceholderConfigurer
extends PropertyPlaceholderConfigurer {
    private String systemProperty;
    private List<Resource> locations;

    public String getSystemProperty() {
        return this.systemProperty;
    }

    public void setSystemProperty(String systemProperty) {
        this.systemProperty = systemProperty;
    }

    public void setLocations(Resource[] locations) {
        this.locations = new ArrayList<Resource>(Arrays.asList(locations));
        super.setLocations(locations);
    }

    protected void loadProperties(Properties props) throws IOException {
        String systemProp;
        if (this.getSystemProperty() != null && (systemProp = System.getProperty(this.getSystemProperty())) != null) {
            File propertiesFile = new File(systemProp);
            this.logger.debug((Object)("Adding (" + propertiesFile.getAbsolutePath() + ") to the locations"));
            if (propertiesFile.exists()) {
                if (this.locations == null) {
                    this.locations = new ArrayList<Resource>();
                }
                this.locations.add((Resource)new FileSystemResource(propertiesFile));
                super.setLocations(this.locations.toArray(new Resource[this.locations.size()]));
            } else {
                throw new FileNotFoundException(propertiesFile.getAbsolutePath());
            }
        }
        super.loadProperties(props);
    }
}

