/*
 * Decompiled with CFR 0.152.
 */
package com.crygier.spring.util.web;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.core.OrderComparator;
import org.springframework.core.Ordered;
import org.springframework.http.MediaType;
import org.springframework.oxm.Marshaller;
import org.springframework.oxm.xstream.XStreamMarshaller;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.Mapping;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerExecutionChain;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.ViewResolver;
import org.springframework.web.servlet.view.AbstractCachingViewResolver;
import org.springframework.web.servlet.view.InternalResourceViewResolver;
import org.springframework.web.servlet.view.json.MappingJacksonJsonView;
import org.springframework.web.servlet.view.xml.MarshallingView;

public class MimeTypeViewResolver
extends AbstractCachingViewResolver
implements Ordered,
InitializingBean {
    public static final Log logger = LogFactory.getLog(MimeTypeViewResolver.class);
    private List<HandlerMapping> handlerMappings;
    private Map<String, ViewResolver> mimeTypeToViewResolver = new HashMap<String, ViewResolver>();
    private String defaultInternalResourcePrefix = "/";
    private String defaultInternalResourceSuffix = ".jsp";
    private int order = Integer.MIN_VALUE;

    protected View loadView(String viewName, Locale locale) throws Exception {
        String name = this.getViewNameFromRequest();
        String acceptHeader = this.getCurrentRequestAttributes().getRequest().getHeader("Accept");
        ArrayList<MediaType> acceptableMediaTypes = null;
        if (StringUtils.hasText((String)acceptHeader)) {
            try {
                acceptableMediaTypes = MediaType.parseMediaTypes((String)acceptHeader);
            }
            catch (Exception e) {
                logger.warn((Object)"Unparsable Accept header, defaulting to text/html");
                acceptableMediaTypes = new ArrayList<MediaType>();
                acceptableMediaTypes.add(MediaType.TEXT_HTML);
            }
        }
        for (MediaType requestedMediaType : acceptableMediaTypes) {
            ViewResolver viewResolver = this.findViewResolverForMediaType(requestedMediaType);
            if (viewResolver == null) continue;
            return viewResolver.resolveViewName(name, locale);
        }
        logger.warn((Object)"No view resolvers found, backing onto Default text/html resolver");
        return this.mimeTypeToViewResolver.get("text/html").resolveViewName(name, locale);
    }

    protected ViewResolver findViewResolverForMediaType(MediaType requestedMediaType) {
        for (String mimeType : this.mimeTypeToViewResolver.keySet()) {
            MediaType searchingType = MediaType.parseMediaType((String)mimeType);
            if (!requestedMediaType.isCompatibleWith(searchingType)) continue;
            return this.mimeTypeToViewResolver.get(mimeType);
        }
        return null;
    }

    protected String getViewNameFromRequest() throws Exception {
        HandlerExecutionChain execution = this.getHandler(this.getCurrentRequestAttributes().getRequest());
        HandlerMethod hm = (HandlerMethod)execution.getHandler();
        String name = hm.getMethod().getName();
        if (hm.getMethod().isAnnotationPresent(ResponseMapping.class)) {
            ResponseMapping responseMapping = hm.getMethod().getAnnotation(ResponseMapping.class);
            name = responseMapping.value()[0];
        }
        return name;
    }

    protected List<HandlerMapping> getHandlerMappings() {
        Map matchingBeans;
        if (this.handlerMappings == null && !(matchingBeans = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)this.getApplicationContext(), HandlerMapping.class, (boolean)true, (boolean)false)).isEmpty()) {
            this.handlerMappings = new ArrayList(matchingBeans.values());
            OrderComparator.sort(this.handlerMappings);
        }
        return this.handlerMappings;
    }

    protected HandlerExecutionChain getHandler(HttpServletRequest request) throws Exception {
        for (HandlerMapping hm : this.getHandlerMappings()) {
            HandlerExecutionChain handler = hm.getHandler(request);
            if (handler == null) continue;
            return handler;
        }
        return null;
    }

    protected Object getCacheKey(String viewName, Locale locale) {
        String name = null;
        try {
            name = this.getViewNameFromRequest();
        }
        catch (Exception e) {
            // empty catch block
        }
        String acceptHeader = this.getCurrentRequestAttributes().getRequest().getHeader("Accept");
        return name + "_" + locale + "_" + acceptHeader;
    }

    public void afterPropertiesSet() throws Exception {
        Object viewResolver;
        if (!this.mimeTypeToViewResolver.containsKey("text/html")) {
            viewResolver = new InternalResourceViewResolver();
            viewResolver.setPrefix(this.defaultInternalResourcePrefix);
            viewResolver.setSuffix(this.defaultInternalResourceSuffix);
            viewResolver.setApplicationContext(this.getApplicationContext());
            this.mimeTypeToViewResolver.put("text/html", (ViewResolver)viewResolver);
        }
        if (!this.mimeTypeToViewResolver.containsKey("application/json")) {
            viewResolver = new ViewResolver(){

                public View resolveViewName(String viewName, Locale locale) throws Exception {
                    MappingJacksonJsonView jsonView = new MappingJacksonJsonView();
                    jsonView.setApplicationContext(MimeTypeViewResolver.this.getApplicationContext());
                    return jsonView;
                }
            };
            this.mimeTypeToViewResolver.put("application/json", (ViewResolver)viewResolver);
        }
        if (!this.mimeTypeToViewResolver.containsKey("text/xml")) {
            viewResolver = new ViewResolver(){

                public View resolveViewName(String viewName, Locale locale) throws Exception {
                    XStreamMarshaller marshaller = new XStreamMarshaller();
                    marshaller.setAutodetectAnnotations(true);
                    MarshallingView view = new MarshallingView((Marshaller)marshaller);
                    return view;
                }
            };
            this.mimeTypeToViewResolver.put("text/xml", (ViewResolver)viewResolver);
        }
    }

    protected ServletRequestAttributes getCurrentRequestAttributes() {
        return (ServletRequestAttributes)RequestContextHolder.currentRequestAttributes();
    }

    public void setMimeTypeToViewResolver(Map<String, ViewResolver> mimeTypeToViewResolver) {
        this.mimeTypeToViewResolver = mimeTypeToViewResolver;
    }

    public void setDefaultInternalResourcePrefix(String defaultInternalResourcePrefix) {
        this.defaultInternalResourcePrefix = defaultInternalResourcePrefix;
    }

    public void setDefaultInternalResourceSuffix(String defaultInternalResourceSuffix) {
        this.defaultInternalResourceSuffix = defaultInternalResourceSuffix;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    @Target(value={ElementType.METHOD, ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Documented
    @Mapping
    public static @interface ResponseMapping {
        public String[] value() default {};
    }
}

