/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.desc;

import dm.jdbc.desc.Const;
import dm.jdbc.desc.DmProperties;
import dm.jdbc.desc.EP;
import dm.jdbc.desc.EPGroup;
import dm.jdbc.driver.DBError;
import dm.jdbc.driver.Resource;
import dm.jdbc.util.ConvertUtil;
import dm.jdbc.util.DriverUtil;
import dm.jdbc.util.StringUtil;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;

public class Configuration {
    public static final int COLUMN_NAME_CASE_DEFAULT = 0;
    public static final int COLUMN_NAME_CASE_UPPDER = 1;
    public static final int COLUMN_NAME_CASE_LOWER = 2;
    public static final int COMPATIBLE_MODE_OFF = 0;
    public static final int COMPATIBLE_MODE_ORACLE = 1;
    public static final int COMPATIBLE_MODE_MYSQL = 2;
    public static final int OSAUTH_OFF = 0;
    public static final int OSAUTH_DBA = 1;
    public static final int OSAUTH_SSO = 2;
    public static final int OSAUTH_AUDITOR = 3;
    public static final int OSAUTH_AUTOMATCH = 4;
    public static int STAT_SQL_REMOVE_LATEST = 0;
    public static int STAT_SQL_REMOVE_OLDEST = 1;
    public static int STAT_FILE_TYPE_CSV = 1;
    public static int STAT_FILE_TYPE_TXT = 0;
    public static final int LOG_OFF = 0;
    public static final int LOG_ERROR = 1;
    public static final int LOG_WARN = 2;
    public static final int LOG_SQL = 3;
    public static final int LOG_INFO = 4;
    public static final int LOG_DEBUG = 5;
    public static final int LOG_ALL = 9;
    public static final int BATCH_OFF = 2;
    public static final int BATCH = 1;
    public static final int LOB_MODE_CACHE_ALL = 2;
    public static final int LOB_MODE_NO_CACHE = 1;
    public static final int MIN_BUF_PREFETCH = 32;
    public static final int MAX_BUF_PREFETCH = 65536;
    public static final int MPP_FLDR_OFF = 0;
    public static final int MPP_FLDR_INSERT = 1;
    public static final int MPP_FLDR_SELECT = 2;
    public static final int RW_SEPARATE_OFF = 0;
    public static final int RW_SEPARATE_CLIENT = 1;
    public static final int RW_SEPARATE_EP_GROUP = 2;
    public static final int RW_SEPARATE_DB = 3;
    public static final Map map = new HashMap();
    private static final Map aliasMap = new HashMap();
    public static final Configuration addressRemap = new Configuration("addressRemap", new String[]{"ADDRESS_REMAP"}, "", null, null, false, "description.addressRemap");
    public static final Configuration userRemap = new Configuration("userRemap", new String[]{"USER_REMAP"}, "", null, null, false, "description.userRemap");
    public static final Configuration dmSvcConf = new Configuration("dmSvcConf", null, "", null, null, false, "description.dmSvcConf");
    public static final Configuration url = new Configuration("url", null, "", null, null, true, "description.url");
    public static final Configuration host = new Configuration("host", null, "localhost", null, null, true, "description.host");
    public static final Configuration port = new Configuration("port", null, 5236, 0, Integer.MAX_VALUE, true, "description.port");
    public static final Configuration user = new Configuration("user", null, null, null, null, true, "description.user");
    public static final Configuration password = new Configuration("password", null, "", null, null, true, "description.password");
    public static final Configuration language = new Configuration("language", new String[]{"LANGUAGE"}, StringUtil.equals(Locale.getDefault().getLanguage(), "zh") ? 0 : 1, 0, 1, false, "description.language");
    public static final Configuration appName = new Configuration("appName", new String[]{"APP_NAME"}, "", null, null, false, "description.appName");
    public static final Configuration osName = new Configuration("osName", new String[]{"OS_NAME"}, System.getProperty("os.name", ""), null, null, false, "description.osName");
    public static final Configuration connectTimeout = new Configuration("connectTimeout", new String[]{"CONNECT_TIMEOUT"}, 5000, 0, Integer.MAX_VALUE, false, "description.connectTimeout");
    public static final Configuration sessionTimeout = new Configuration("sessionTimeout", new String[]{"SESSION_TIMEOUT"}, 0, 0, Integer.MAX_VALUE, false, "description.sessionTimeout");
    public static final Configuration socketTimeout = new Configuration("socketTimeout", new String[]{"SOCKET_TIMEOUT"}, 0, 0, Integer.MAX_VALUE, false, "description.socketTimeout");
    public static final Configuration keepAlive = new Configuration("keepAlive", new String[]{"KEEP_ALIVE"}, true, null, null, false, "description.keepAlive");
    public static final Configuration autoCommit = new Configuration("autoCommit", new String[]{"AUTO_COMMIT"}, true, null, null, false, "description.autoCommit");
    public static final Configuration alwaysAllowCommit = new Configuration("alwaysAllowCommit", new String[]{"ALWAYSE_ALLOW_COMMIT", "ALWAYS_ALLOW_COMMIT", "alwayseAllowCommit"}, true, null, null, false, "description.alwayseAllowCommit");
    public static final Configuration localTimezone = new Configuration("localTimezone", new String[]{"TIMEZONE", "TIME_ZONE", "LOCAL_TIME_ZONE"}, Const.TIME_ZONE_DEFAULT, -720, 720, false, "description.localTimezone");
    public static final Configuration keyWords = new Configuration("keyWords", new String[]{"PRIMARY_KEY", "KEY_WORDS"}, null, null, null, false, "description.keyWords");
    public static final Configuration compatibleMode = new Configuration("compatibleMode", new String[]{"COMPATIBLE_MODE"}, 0, new Integer[]{2, 1}, false, "description.compatibleMode");
    public static final Configuration batchType = new Configuration("batchType", new String[]{"BATCH_TYPE"}, 1, new Integer[]{2, 1}, false, "description.batchType");
    public static final Configuration batchContinueOnError = new Configuration("batchContinuteOnError", new String[]{"continueBatchOnError", "BATCH_CONTINUE_ON_ERROR", "CONTINUE_BATCH_ON_ERROR"}, false, null, null, false, "description.continueBatchOnError");
    public static final Configuration batchNotOnCall = new Configuration("batchNotOnCall", new String[]{"callBatchNot", "CALL_BATCH_NOT", "BATCH_NOT_ON_CALL"}, false, null, null, false, "description.callBatchNot");
    public static final Configuration batchAllowMaxErrors = new Configuration("batchAllowMaxErrors", new String[]{"BATCH_ALLOW_MAX_ERRORS"}, 0, 0, Integer.MAX_VALUE, false, "description.batchAllowMaxErrors");
    public static final Configuration bufPrefetch = new Configuration("bufPrefetch", new String[]{"BUF_PREFETCH"}, 0, 0, Integer.MAX_VALUE, false, "description.bufPrefetch");
    public static final Configuration clobAsString = new Configuration("clobAsString", new String[]{"CLOB_AS_STRING"}, false, null, null, false, "description.clobAsString");
    public static final Configuration columnNameCase = new Configuration("columnNameCase", new String[]{"COLUMN_NAME_CASE", "columnNameUpperCase", "COLUMN_NAME_UPPER_CASE"}, "", null, null, false, "description.columnNameCase");
    public static final Configuration databaseProductName = new Configuration("databaseProductName", new String[]{"DATABASE_PRODUCT_NAME"}, "", null, null, false, "description.databaseProductName");
    public static final Configuration dbmdChkPrv = new Configuration("dbmdChkPrv", new String[]{"DBMD_CHK_PRV"}, true, null, null, false, "description.dbmdChkPrv");
    public static final Configuration escapeProcess = new Configuration("escapeProcess", new String[]{"ESCAPE_PROCESS"}, true, null, null, false, "description.escapeProcess");
    public static final Configuration ignoreCase = new Configuration("ignoreCase", new String[]{"IGNORE_CASE"}, true, null, null, false, "description.ignoreCase");
    public static final Configuration isBdtaRS = new Configuration("isBdtaRS", new String[]{"IS_BDTA_RS"}, false, null, null, false, "description.isBdtaRS");
    public static final Configuration lobMode = new Configuration("lobMode", new String[]{"LOB_MODE"}, 1, new Integer[]{1, 2}, false, "description.lobMode");
    public static final Configuration maxRows = new Configuration("maxRows", new String[]{"MAX_ROWS"}, 0, 0, Integer.MAX_VALUE, false, "description.maxRows");
    public static final Configuration prepareOptimize = new Configuration("prepareOptimize", new String[]{"PREPARE_OPTIMIZE"}, false, null, null, false, "description.prepareOptimize");
    public static final Configuration pstmtPoolSize = new Configuration("pstmtPoolSize", new String[]{"PSTMT_POOL_SIZE"}, 0, 0, Integer.MAX_VALUE, false, "description.pstmtPoolSize");
    public static final Configuration pstmtPoolValidTime = new Configuration("pstmtPoolValidTime", new String[]{"PSTMT_POOL_VALID_TIME"}, 0, 0, Integer.MAX_VALUE, false, "description.pstmtPoolValidTime");
    public static final Configuration resultSetType = new Configuration("resultSetType", new String[]{"RESULT_SET_TYPE"}, 1003, new Integer[]{1003, 1004, 1005}, false, "description.resultSetType");
    public static final Configuration stmtPoolSize = new Configuration("stmtPoolSize", new String[]{"STMT_POOL_SIZE"}, 15, 0, Integer.MAX_VALUE, false, "description.stmtPoolSize");
    public static final Configuration sessEncode = new Configuration("sessEncode", new String[]{"SESS_ENCODE"}, "", null, null, false, "description.sessEncode");
    public static final Configuration enRsCache = new Configuration("enRsCache", new String[]{"ENABLE_RS_CACHE", "EN_RS_CACHE"}, false, null, null, false, "description.enRsCache");
    public static final Configuration rsCacheSize = new Configuration("rsCacheSize", new String[]{"RS_CACHE_SIZE"}, 20, 0, Integer.MAX_VALUE, false, "description.rsCacheSize");
    public static final Configuration rsRefreshFreq = new Configuration("rsRefreshFreq", new String[]{"RS_REFRESH_FREQ"}, 10, 0, Integer.MAX_VALUE, false, "description.rsRefreshFreq");
    public static final Configuration reconnect = new Configuration("autoReconnect", new String[]{"DO_SWITCH", "AUTO_RECONNECT", "doSwitch", "reconnect"}, 0, null, false, "description.doSwitch");
    public static final Configuration switchTimes = new Configuration("switchTimes", new String[]{"SWITCH_TIME", "SWITCH_TIMES"}, 1, 1, Integer.MAX_VALUE, false, "description.switchTimes");
    public static final Configuration switchInterval = new Configuration("switchInterval", new String[]{"SWITCH_INTERVAL"}, 1000, 0, Integer.MAX_VALUE, false, "description.switchInterval");
    public static final Configuration checkFreq = new Configuration("checkFreq", new String[]{"CHECK_FREQ"}, 300000, 0, Integer.MAX_VALUE, false, "description.epStatusCheckFreq");
    public static final Configuration loginMode = new Configuration("loginMode", new String[]{"LOGIN_PRIMARY", "LOGIN_MODE"}, 4, new Integer[]{0, 1, 2, 3, 4}, false, "description.loginMode");
    public static final Configuration loginStatus = new Configuration("loginStatus", new String[]{"LOGIN_STATUS"}, 0, new Integer[]{0, 5, 3, 4}, false, "description.loginStatus");
    public static final Configuration loginDscCtrl = new Configuration("loginDscCtrl", new String[]{"LOGIN_DSC_CTRL"}, false, null, null, false, "description.loginDscCtrl");
    public static final Configuration epSelector = new Configuration("epSelector", new String[]{"epSelection", "EP_SELECTION", "EP_SELECTOR"}, 0, new Integer[]{0, 1}, false, "description.epSelector");
    public static final Configuration cluster = new Configuration("cluster", null, 0, new Integer[]{0, 4, 3, 2, 1}, false, "description.cluster");
    public static final Configuration mppLocal = new Configuration("mppLocal", new String[]{"MPP_LOCAL"}, false, null, null, false, "description.mppLocal");
    public static final Configuration mppOpt = new Configuration("mppOpt", new String[]{"MPP_OPT"}, 0, new Integer[]{0, 1, 2, 0}, false, "description.mppOpt");
    public static final Configuration rwSeparate = new Configuration("rwSeparate", new String[]{"RW_SEPARATE"}, 0, new Integer[]{0, 3, 1, 2}, false, "description.rwSeparate");
    public static final Configuration rwPercent = new Configuration("rwPercent", new String[]{"RW_PERCENT"}, 25, 0, 100, false, "description.rwPercent");
    public static final Configuration rwAutoDistribute = new Configuration("rwAutoDistribute", new String[]{"RW_AUTO_DISTRIBUTE"}, true, null, null, false, "description.rwAutoDistribute");
    public static final Configuration rwHA = new Configuration("rwHA", new String[]{"RW_HA"}, false, null, null, false, "description.rwHA");
    public static final Configuration rwStandbyRecoverTime = new Configuration("rwStandbyRecoverTime", new String[]{"RW_STANDBY_RECOVER_TIME"}, 60000, 0, Integer.MAX_VALUE, false, "description.rwStandbyRecoverTime");
    public static final Configuration rwIgnoreSql = new Configuration("rwIgnoreSql", new String[]{"RW_IGNORE_SQL"}, false, null, null, false, "description.rwIgnoreSql");
    public static final Configuration dbAliveCheckFreq = new Configuration("dbAliveCheckFreq", new String[]{"DB_ALIVE_CHECK_FREQ"}, 0, 0, Integer.MAX_VALUE, false, "description.dbAliveCheckFreq");
    public static final Configuration dbAliveCheckTimeout = new Configuration("dbAliveCheckTimeout", new String[]{"DB_ALIVE_CHECK_TIMEOUT"}, 10000, 0, Integer.MAX_VALUE, false, "description.dbAliveCheckTimeout");
    public static final Configuration logLevel = new Configuration("logLevel", new String[]{"LOG_LEVEL"}, 0, new Integer[]{0, 9, 5, 1, 4, 3, 2}, false, "description.logLevel");
    public static final Configuration logDir = new Configuration("logDir", new String[]{"LOG_DIR"}, DriverUtil.formatDir(System.getProperty("user.dir")), null, null, false, "description.logDir");
    public static final Configuration logFlushFreq = new Configuration("logFlushFreq", new String[]{"LOG_FLUSH_FREQ"}, 30, 0, Integer.MAX_VALUE, false, "description.logFlushFreq");
    public static final Configuration statEnable = new Configuration("statEnable", new String[]{"STAT_ENABLE"}, false, null, null, false, "description.statEnable");
    public static final Configuration statDir = new Configuration("statDir", new String[]{"STAT_DIR"}, DriverUtil.formatDir(System.getProperty("user.statDir")), null, null, false, "description.addressRemap");
    public static final Configuration statFileType = new Configuration("statFileType", new String[]{"STAT_FILE_TYPE"}, STAT_FILE_TYPE_CSV, new Integer[]{STAT_FILE_TYPE_CSV, STAT_FILE_TYPE_TXT}, false, "description.statFileType");
    public static final Configuration statFlushFreq = new Configuration("statFlushFreq", new String[]{"STAT_FLUSH_FREQ"}, 30, 0, Integer.MAX_VALUE, false, "description.statFlushFreq");
    public static final Configuration statHighFreqSqlCount = new Configuration("statHighFreqSqlCount", new String[]{"STAT_HIGH_FREQ_SQL_COUNT"}, 100, 0, 1000, false, "description.statHighFreqSqlCount");
    public static final Configuration statSlowSqlCount = new Configuration("statSlowSqlCount", new String[]{"STAT_SLOW_SQL_COUNT"}, 100, 0, 1000, false, "description.statSlowSqlCount");
    public static final Configuration statSqlMaxCount = new Configuration("statSqlMaxCount", new String[]{"STAT_MAX_SQL_COUNT"}, 1000, 0, 100000, false, "description.statSqlMaxCount");
    public static final Configuration statSqlRemoveMode = new Configuration("statSqlRemoveMode", new String[]{"STAT_SQL_REMOVE_LATEST"}, STAT_SQL_REMOVE_LATEST, new Integer[]{STAT_SQL_REMOVE_LATEST, STAT_SQL_REMOVE_OLDEST}, false, "description.statSqlRemoveMode");
    public static final Configuration loginEncrypt = new Configuration("loginEncrypt", new String[]{"LOGIN_ENCRYPT", "COMMUNICATION_ENCRYPT"}, true, null, null, false, "description.loginEncrypt");
    public static final Configuration cipherPath = new Configuration("cipherPath", new String[]{"CIPHER_PATH"}, "", null, null, false, "description.cipherPath");
    public static final Configuration kerberosLoginConfPath = new Configuration("kerberosLoginConfPath", new String[]{"KERBEROS_LOGIN_CONF_PATH"}, "", null, null, false, "description.kerberosLoginConfPath");
    public static final Configuration loginCertificate = new Configuration("loginCertificate", new String[]{"LOGIN_CERTIFICATE"}, "", null, null, false, "description.loginCertificate");
    public static final Configuration osAuthType = new Configuration("osAuthType", new String[]{"OS_AUTH_TYPE"}, 0, new Integer[]{3, 4, 1, 0, 2}, false, "description.osAuthType");
    public static final Configuration sslFilesPath = new Configuration("sslFilesPath", new String[]{"SSL_FILES_PATH"}, "", null, null, false, "description.sslFilesPath");
    public static final Configuration sslKeystorePass = new Configuration("sslKeystorePass", new String[]{"SSL_KEYSTORE_PASS"}, "", null, null, false, "description.sslKeystorePass");
    public static final Configuration uKeyName = new Configuration("uKeyName", new String[]{"UKEY_NAME"}, "", null, null, false, "description.uKeyName");
    public static final Configuration uKeyPin = new Configuration("uKeyPin", new String[]{"UKEY_PIN"}, "", null, null, false, "description.uKeyPin");
    public static final Configuration compress = new Configuration("compress", new String[]{"COMPRESS_MSG"}, 0, new Integer[]{0, 2, 1}, false, "description.compress");
    public static final Configuration compressID = new Configuration("compressID", new String[]{"COMPRESS_ID"}, 0, new Integer[]{0, 1}, false, "description.compressID");
    public static final Configuration markConf = new Configuration("markConf", new String[]{"MARK_CONF"}, null, null, null, false, "description.markConf");
    public static final Configuration schema = new Configuration("schema", new String[]{"SCHEMA"}, null, null, null, false, "description.schema");
    public static final Configuration unixSocketFile = new Configuration("unixSocketFile", new String[]{"UNIX_SOCKET_FILE"}, null, null, null, false, "description.unixSocketFile");
    public static final Configuration sslProtocol = new Configuration("sslProtocol", new String[]{"SSL_PROTOCOL"}, null, null, false, "description.sslProtocol");
    public static final Configuration gwdsn = new Configuration("GWDSN", null, "", null, null, false, "description.gwdsn");
    public static final Configuration isCompress = new Configuration("isCompress", new String[]{"IS_COMPRESS"}, false, null, null, false, "description.isCompress");
    public static final Configuration comOra = new Configuration("comOra", new String[]{"COM_ORA"}, false, null, null, false, "description.comOra");
    public static final Configuration bufferType = new Configuration("bufferType", new String[]{"BUFFER_TYPE"}, 0, new Integer[]{0, 2, 1}, false, "description.bufferType");
    public static final Configuration logBufferSize = new Configuration("logBufferSize", new String[]{"LOG_BUFFER_SIZE"}, 32768, 0, Integer.MAX_VALUE, false, "description.logBufferSize");
    public static final Configuration epGroup = new Configuration("epGroup", null, null, null, false, "description.epGroup");
    public static final Configuration rwStandby = new Configuration("rwStandby", null, false, null, null, false, "description.rwStandby");
    private String name;
    private boolean required;
    private Object defaultValue;
    private Object minValue;
    private Object maxValue;
    private Object[] validValues;
    private String description;

    public Configuration(String string, String[] stringArray, Object object, Object object2, Object object3, boolean bl, String string2) {
        this.name = string;
        this.defaultValue = object;
        this.maxValue = object3;
        this.minValue = object2;
        this.required = bl;
        this.description = string2;
        map.put(string.toLowerCase(), this);
        if (stringArray != null) {
            String[] stringArray2 = stringArray;
            int n2 = stringArray.length;
            int n3 = 0;
            while (n3 < n2) {
                String string3 = stringArray2[n3];
                aliasMap.put(string3.toLowerCase(), this);
                ++n3;
            }
        }
    }

    public Configuration(String string, String[] stringArray, Object object, Object[] objectArray, boolean bl, String string2) {
        this(string, stringArray, object, null, null, bl, string2);
        this.validValues = objectArray;
    }

    public static Configuration valueOf(String string) {
        Configuration configuration = (Configuration)map.get(string = string.toLowerCase());
        if (configuration != null) {
            return configuration;
        }
        return (Configuration)aliasMap.get(string);
    }

    public static Collection values() {
        return map.values();
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return Resource.get(this.description);
    }

    public boolean isRequired() {
        return this.required;
    }

    public Object getDefault() {
        return this.defaultValue;
    }

    public Object getMax() {
        return this.maxValue;
    }

    public Object getMin() {
        return this.minValue;
    }

    public Object[] getValidValues() {
        return this.validValues;
    }

    public static int parseCluster(DmProperties dmProperties) {
        String string = dmProperties.getProperty(cluster.getName());
        if (StringUtil.isNotEmpty(string) && !StringUtil.isDigit(string)) {
            if (StringUtil.equalsIgnoreCase(string, "dsc")) {
                return 3;
            }
            if (StringUtil.equalsIgnoreCase(string, "rw")) {
                return 1;
            }
            if (StringUtil.equalsIgnoreCase(string, "dw")) {
                return 2;
            }
            if (StringUtil.equalsIgnoreCase(string, "mpp")) {
                return 4;
            }
            if (StringUtil.equalsIgnoreCase(string, "normal")) {
                return 0;
            }
            return (Integer)cluster.getDefault();
        }
        return (byte)dmProperties.getInt(cluster);
    }

    public static int parseCompatibleMode(DmProperties dmProperties) {
        String string = dmProperties.getProperty(compatibleMode.getName());
        if (StringUtil.isNotEmpty(string) && !StringUtil.isDigit(string)) {
            if (StringUtil.equalsIgnoreCase(string, "oracle")) {
                return 1;
            }
            if (StringUtil.equalsIgnoreCase(string, "mysql")) {
                return 2;
            }
            return (Integer)compatibleMode.getDefault();
        }
        string = dmProperties.getProperty(comOra.getName());
        if (StringUtil.isNotEmpty(string)) {
            return dmProperties.getBoolean(comOra) ? 1 : 0;
        }
        return dmProperties.getInt(compatibleMode);
    }

    public static int parseColumnNameCase(String string) {
        if (StringUtil.isEmpty(string)) {
            return 0;
        }
        if (StringUtil.equalsIgnoreCase("upper", string) || StringUtil.equals(String.valueOf(1), string)) {
            return 1;
        }
        if (StringUtil.equalsIgnoreCase("lower", string) || StringUtil.equals(String.valueOf(2), string)) {
            return 2;
        }
        boolean bl = ConvertUtil.toBoolean(string);
        return bl ? 1 : 0;
    }

    public static byte parseOsAuthType(DmProperties dmProperties) {
        String string = dmProperties.getProperty(osAuthType.getName());
        if (StringUtil.isNotEmpty(string) && !StringUtil.isDigit(string)) {
            if (StringUtil.equalsIgnoreCase(string, "SYSDBA")) {
                return 1;
            }
            if (StringUtil.equalsIgnoreCase(string, "SYSAUDITOR")) {
                return 3;
            }
            if (StringUtil.equalsIgnoreCase(string, "SYSSSO")) {
                return 2;
            }
            if (StringUtil.equalsIgnoreCase(string, "AUTO")) {
                return 4;
            }
            if (StringUtil.equalsIgnoreCase(string, "OFF")) {
                return 0;
            }
            return ((Integer)osAuthType.getDefault()).byteValue();
        }
        return (byte)dmProperties.getInt(osAuthType);
    }

    public static int parseLogLevel(DmProperties dmProperties) {
        int n2 = (Integer)logLevel.getDefault();
        String string = dmProperties.getProperty(logLevel.getName());
        if (StringUtil.isNotEmpty(string) && !StringUtil.isDigit(string)) {
            if ("DEBUG".equalsIgnoreCase(string)) {
                n2 = 5;
            } else if ("INFO".equalsIgnoreCase(string)) {
                n2 = 4;
            } else if ("SQL".equalsIgnoreCase(string)) {
                n2 = 3;
            } else if ("warn".equalsIgnoreCase(string)) {
                n2 = 2;
            } else if ("error".equalsIgnoreCase(string)) {
                n2 = 1;
            } else if ("off".equalsIgnoreCase(string)) {
                n2 = 0;
            } else if ("all".equalsIgnoreCase(string)) {
                n2 = 9;
            }
        } else {
            n2 = dmProperties.getInt(logLevel);
        }
        return n2;
    }

    public static int parseStatSqlRemoveMode(DmProperties dmProperties) {
        String string = dmProperties.getProperty(statSqlRemoveMode.getName());
        if (StringUtil.isNotEmpty(string) && !StringUtil.isDigit(string)) {
            if ("oldest".equalsIgnoreCase(string) || "eldest".equalsIgnoreCase(string)) {
                return STAT_SQL_REMOVE_OLDEST;
            }
            if ("latest".equalsIgnoreCase(string)) {
                return STAT_SQL_REMOVE_LATEST;
            }
            return (Integer)statSqlRemoveMode.getDefault();
        }
        return dmProperties.getInt(statSqlRemoveMode);
    }

    public static Locale parseLanguage(DmProperties dmProperties) {
        String string = dmProperties.getProperty(language.getName());
        if ("cn".equalsIgnoreCase(string)) {
            return Locale.CHINA;
        }
        if ("en".equalsIgnoreCase(string)) {
            return Locale.US;
        }
        return Locale.getDefault();
    }

    public static EPGroup parseEpGroup(String string, String string2) {
        String[] stringArray = string2.split(",");
        ArrayList<EP> arrayList = new ArrayList<EP>();
        int n2 = 0;
        while (n2 < stringArray.length) {
            int n3;
            String string3;
            EP eP = null;
            int n4 = stringArray[n2].indexOf("[");
            int n5 = -1;
            if (n4 != -1) {
                n5 = stringArray[n2].indexOf("]", n4);
            }
            if (n5 != -1) {
                string3 = stringArray[n2].substring(n4 + 1, n5);
                int n6 = stringArray[n2].indexOf(":", n5);
                n3 = n6 != -1 ? Integer.parseInt(stringArray[n2].substring(n6 + 1).trim()) : 5236;
                eP = new EP(string3, n3);
                eP.epSeqno = arrayList.size();
                arrayList.add(eP);
            } else {
                String[] stringArray2 = stringArray[n2].split(":");
                string3 = stringArray2[0].trim();
                n3 = stringArray2.length >= 2 ? Integer.parseInt(stringArray2[1]) : 5236;
                eP = new EP(string3, n3);
                eP.epSeqno = arrayList.size();
                arrayList.add(eP);
            }
            ++n2;
        }
        return arrayList.size() > 0 ? new EPGroup(string, arrayList) : null;
    }

    public static void parseHostPort(String string, DmProperties dmProperties) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":/[]", true);
        String string2 = null;
        if (!stringTokenizer.hasMoreTokens() || StringUtil.isEmpty(string2 = stringTokenizer.nextToken())) {
            return;
        }
        if ("[".equals(string2 = StringUtil.trimToEmpty(string2))) {
            int n2 = string.indexOf("[");
            int n3 = string.indexOf("]");
            String string3 = StringUtil.trimToEmpty(string.substring(n2 + 1, n3));
            try {
                InetAddress inetAddress = InetAddress.getByName(string3);
                string3 = inetAddress.getHostAddress();
                dmProperties.setProperty(host.getName(), string3);
                while (stringTokenizer.hasMoreTokens()) {
                    string2 = StringUtil.trimToEmpty(stringTokenizer.nextToken());
                    if ("]".equals(string2)) break;
                }
                string2 = stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : null;
            }
            catch (Exception exception) {
                DBError.ECJDBC_CONN_URL_ERROR.throwz(new Object[0]);
            }
        } else if (!":".equals(string2) && !"/".equals(string2)) {
            dmProperties.setProperty(host.getName(), string2);
            String string4 = string2 = stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : null;
        }
        if (":".equals(string2) && stringTokenizer.hasMoreTokens() && StringUtil.isNotEmpty(string2 = stringTokenizer.nextToken())) {
            dmProperties.setProperty(port.getName(), StringUtil.trimToEmpty(string2));
        }
    }

    public static int parseStatFileType(DmProperties dmProperties) {
        String string = dmProperties.getProperty(statFileType.getName());
        if (StringUtil.isNotEmpty(string) && !StringUtil.isDigit(string)) {
            if (StringUtil.equals(string, "csv")) {
                return STAT_FILE_TYPE_CSV;
            }
            if (StringUtil.equals(string, "txt")) {
                return STAT_FILE_TYPE_TXT;
            }
            return (Integer)statFileType.getDefault();
        }
        return dmProperties.getInt(statFileType);
    }

    public static void main(String[] stringArray) {
        for (Configuration configuration : map.values()) {
            System.out.println("description." + configuration.name);
        }
    }
}

