/*
 * Decompiled with CFR 0.152.
 */
package com.dinstone.beanstalkc.internal;

import com.dinstone.beanstalkc.ConnectionException;
import com.dinstone.beanstalkc.internal.SessionUtil;
import com.dinstone.beanstalkc.internal.operation.Operation;
import java.util.Queue;
import org.apache.mina.core.service.IoHandlerAdapter;
import org.apache.mina.core.session.IdleStatus;
import org.apache.mina.core.session.IoSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionHandler
extends IoHandlerAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(ConnectionHandler.class);

    public void sessionCreated(IoSession session) throws Exception {
        SessionUtil.setOperationQueue(session);
    }

    public void sessionIdle(IoSession session, IdleStatus status) throws Exception {
        if (status == IdleStatus.READER_IDLE) {
            session.close(true);
        }
    }

    public void sessionClosed(IoSession session) throws Exception {
        Operation<?> operation;
        LOG.info("Session[{}] is closed", (Object)session.getId());
        Queue<Operation<?>> queue = SessionUtil.getOperationQueue(session);
        while ((operation = queue.poll()) != null) {
            operation.getOperationFuture().setException(new ConnectionException("connection is closed"));
        }
    }

    public void exceptionCaught(IoSession session, Throwable cause) throws Exception {
        LOG.error("Unhandled Exception", cause);
        session.close(true);
    }
}

