/*
 * Decompiled with CFR 0.152.
 */
package com.dinstone.beanstalkc.internal;

import com.dinstone.beanstalkc.BeanstalkClient;
import com.dinstone.beanstalkc.Configuration;
import com.dinstone.beanstalkc.Job;
import com.dinstone.beanstalkc.internal.Connection;
import com.dinstone.beanstalkc.internal.ConnectionFactory;
import com.dinstone.beanstalkc.internal.ConnectionInitializer;
import com.dinstone.beanstalkc.internal.OperationFuture;
import com.dinstone.beanstalkc.internal.operation.BuryOperation;
import com.dinstone.beanstalkc.internal.operation.DeleteOperation;
import com.dinstone.beanstalkc.internal.operation.IgnoreOperation;
import com.dinstone.beanstalkc.internal.operation.KickOperation;
import com.dinstone.beanstalkc.internal.operation.ListTubeOperation;
import com.dinstone.beanstalkc.internal.operation.PeekOperation;
import com.dinstone.beanstalkc.internal.operation.PutOperation;
import com.dinstone.beanstalkc.internal.operation.QuitOperation;
import com.dinstone.beanstalkc.internal.operation.ReleaseOperation;
import com.dinstone.beanstalkc.internal.operation.ReserveOperation;
import com.dinstone.beanstalkc.internal.operation.StatsOperation;
import com.dinstone.beanstalkc.internal.operation.TouchOperation;
import com.dinstone.beanstalkc.internal.operation.UseOperation;
import com.dinstone.beanstalkc.internal.operation.WatchOperation;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class DefaultBeanstalkClient
implements BeanstalkClient {
    private Connection connection;
    private long operationTimeout;
    private Configuration config;

    public DefaultBeanstalkClient(Configuration config) {
        this(config, null);
    }

    public DefaultBeanstalkClient(Configuration config, ConnectionInitializer initer) {
        if (config == null) {
            throw new IllegalArgumentException("config is null");
        }
        this.config = config;
        this.operationTimeout = config.getOperationTimeout();
        this.connection = ConnectionFactory.getInstance().createConnection(config, initer);
    }

    @Override
    public boolean useTube(String tube) {
        UseOperation operation = new UseOperation(tube);
        return this.getBoolean(this.connection.handle(operation));
    }

    @Override
    public long putJob(int priority, int delay, int ttr, byte[] data) {
        int maxLength = this.config.getJobMaxSize();
        if (data != null && data.length > maxLength) {
            throw new IllegalArgumentException("data is too long than " + maxLength);
        }
        PutOperation operation = new PutOperation(priority, delay, ttr, data);
        OperationFuture<Long> future = this.connection.handle(operation);
        try {
            return future.get(this.operationTimeout, TimeUnit.SECONDS);
        }
        catch (TimeoutException e) {
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean ignoreTube(String tube) {
        IgnoreOperation operation = new IgnoreOperation(tube);
        return this.getBoolean(this.connection.handle(operation));
    }

    @Override
    public boolean watchTube(String tube) {
        WatchOperation operation = new WatchOperation(tube);
        return this.getBoolean(this.connection.handle(operation));
    }

    @Override
    public boolean deleteJob(long id) {
        DeleteOperation operation = new DeleteOperation(id);
        return this.getBoolean(this.connection.handle(operation));
    }

    @Override
    public boolean touchJob(long id) {
        TouchOperation operation = new TouchOperation(id);
        return this.getBoolean(this.connection.handle(operation));
    }

    @Override
    public Job reserveJob(long timeout) {
        ReserveOperation operation = new ReserveOperation(timeout);
        OperationFuture<Job> future = this.connection.handle(operation);
        try {
            return future.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean releaseJob(long id, int priority, int delay) {
        ReleaseOperation operation = new ReleaseOperation(id, priority, delay);
        return this.getBoolean(this.connection.handle(operation));
    }

    @Override
    public boolean buryJob(long id, int priority) {
        BuryOperation operation = new BuryOperation(id, priority);
        return this.getBoolean(this.connection.handle(operation));
    }

    @Override
    public void close() {
        this.connection.close();
        ConnectionFactory.getInstance().releaseConnection(this.config);
    }

    public void quit() {
        QuitOperation operation = new QuitOperation();
        this.getBoolean(this.connection.handle(operation));
    }

    private boolean getBoolean(OperationFuture<Boolean> future) {
        try {
            return future.get(this.operationTimeout, TimeUnit.SECONDS);
        }
        catch (TimeoutException e) {
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    @Override
    public long kick(long bound) {
        KickOperation operation = new KickOperation(bound);
        try {
            return this.connection.handle(operation).get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    @Override
    public Job peek(long jobId) {
        PeekOperation operation = new PeekOperation(jobId);
        try {
            return this.connection.handle(operation).get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    @Override
    public Job peekReady() {
        PeekOperation operation = new PeekOperation(PeekOperation.Type.ready);
        try {
            return this.connection.handle(operation).get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    @Override
    public Job peekDelayed() {
        PeekOperation operation = new PeekOperation(PeekOperation.Type.delayed);
        try {
            return this.connection.handle(operation).get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    @Override
    public Job peekBuried() {
        PeekOperation operation = new PeekOperation(PeekOperation.Type.buried);
        try {
            return this.connection.handle(operation).get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    @Override
    public Map<String, String> statsJob(long jobId) {
        StatsOperation operation = new StatsOperation(jobId);
        try {
            return this.connection.handle(operation).get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    @Override
    public Map<String, String> statsTube(String tubeName) {
        StatsOperation operation = new StatsOperation(tubeName);
        try {
            return this.connection.handle(operation).get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    @Override
    public Map<String, String> stats() {
        StatsOperation operation = new StatsOperation();
        try {
            return this.connection.handle(operation).get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<String> listTubes() {
        ListTubeOperation operation = new ListTubeOperation(ListTubeOperation.Type.all);
        try {
            return this.connection.handle(operation).get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    @Override
    public String listTubeUsed() {
        ListTubeOperation operation = new ListTubeOperation(ListTubeOperation.Type.used);
        try {
            return this.connection.handle(operation).get().get(0);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<String> listTubeWatched() {
        ListTubeOperation operation = new ListTubeOperation(ListTubeOperation.Type.watched);
        try {
            return this.connection.handle(operation).get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }
}

