/*
 * Decompiled with CFR 0.152.
 */
package com.dinstone.beanstalkc.internal;

import com.dinstone.beanstalkc.Configuration;
import com.dinstone.beanstalkc.ConnectionException;
import com.dinstone.beanstalkc.internal.ConnectionHandler;
import com.dinstone.beanstalkc.internal.Connector;
import com.dinstone.beanstalkc.internal.codec.OperationDecoder;
import com.dinstone.beanstalkc.internal.codec.OperationEncoder;
import java.net.InetSocketAddress;
import java.nio.charset.Charset;
import org.apache.mina.core.filterchain.DefaultIoFilterChainBuilder;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.future.ConnectFuture;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.filter.codec.ProtocolDecoder;
import org.apache.mina.filter.codec.ProtocolEncoder;
import org.apache.mina.transport.socket.SocketSessionConfig;
import org.apache.mina.transport.socket.nio.NioSocketConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultConnector
implements Connector {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultConnector.class);
    private NioSocketConnector ioConnector;
    private int refCount;

    public DefaultConnector(Configuration config) {
        this.initConnector(config);
    }

    private void initConnector(Configuration config) {
        this.ioConnector = new NioSocketConnector();
        this.ioConnector.setConnectTimeoutMillis((long)config.getConnectTimeout());
        SocketSessionConfig sessionConfig = this.ioConnector.getSessionConfig();
        LOG.debug("KeepAlive is {}", (Object)sessionConfig.isKeepAlive());
        LOG.debug("ReadBufferSize is {}", (Object)sessionConfig.getReadBufferSize());
        LOG.debug("SendBufferSize is {}", (Object)sessionConfig.getSendBufferSize());
        sessionConfig.setReaderIdleTime(config.getReadTimeout());
        DefaultIoFilterChainBuilder chainBuilder = this.ioConnector.getFilterChain();
        String charsetName = config.getProtocolCharset();
        Charset charset = Charset.forName(charsetName == null ? "ASCII" : charsetName);
        LOG.debug("beanstalk.protocol.charset is {}", (Object)charset);
        final OperationEncoder encoder = new OperationEncoder(charset);
        final OperationDecoder decoder = new OperationDecoder(charset);
        chainBuilder.addLast("codec", (IoFilter)new ProtocolCodecFilter(new ProtocolCodecFactory(){

            public ProtocolEncoder getEncoder(IoSession session) throws Exception {
                return encoder;
            }

            public ProtocolDecoder getDecoder(IoSession session) throws Exception {
                return decoder;
            }
        }));
        this.ioConnector.setHandler((IoHandler)new ConnectionHandler());
        InetSocketAddress address = new InetSocketAddress(config.getServiceHost(), config.getServicePort());
        this.ioConnector.setDefaultRemoteAddress(address);
    }

    @Override
    public IoSession createSession() {
        LOG.debug("Connecting to beanstalkd service on {}", (Object)this.ioConnector.getDefaultRemoteAddress());
        ConnectFuture cf = this.ioConnector.connect().awaitUninterruptibly();
        try {
            IoSession session = cf.getSession();
            return session;
        }
        catch (RuntimeException e) {
            throw new ConnectionException("can't connect beanstalkd service on " + this.ioConnector.getDefaultRemoteAddress(), e);
        }
    }

    @Override
    public void dispose() {
        this.ioConnector.dispose(false);
    }

    public void incrementRefCount() {
        ++this.refCount;
    }

    public void decrementRefCount() {
        if (this.refCount > 0) {
            --this.refCount;
        }
    }

    public boolean isZeroRefCount() {
        return this.refCount == 0;
    }
}

