/*
 * Decompiled with CFR 0.152.
 */
package com.dinstone.beanstalkc.internal;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.mina.core.RuntimeIoException;

public class OperationFuture<T> {
    private T result;
    private Throwable exception;
    private Lock lock = new ReentrantLock();
    private Condition ready = this.lock.newCondition();
    private boolean done;

    public boolean isDone() {
        this.lock.lock();
        try {
            boolean bl = this.done;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public T get() throws InterruptedException {
        this.lock.lock();
        try {
            while (!this.done) {
                this.ready.await();
            }
            T t = this.getValue();
            return t;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
        this.lock.lock();
        try {
            boolean success;
            if (!this.done && !(success = this.ready.await(timeout, unit))) {
                throw new TimeoutException("operation timeout (" + timeout + " " + (Object)((Object)unit) + ")");
            }
            T t = this.getValue();
            return t;
        }
        finally {
            this.lock.unlock();
        }
    }

    private T getValue() {
        if (this.result == null && this.exception != null) {
            if (this.exception instanceof RuntimeException) {
                throw (RuntimeException)this.exception;
            }
            if (this.exception instanceof Error) {
                throw (Error)this.exception;
            }
            if (this.exception instanceof IOException || this.exception instanceof Exception) {
                throw new RuntimeIoException(this.exception);
            }
        }
        return this.result;
    }

    public void setResult(T result) {
        this.lock.lock();
        try {
            if (!this.done) {
                this.result = result;
                this.done = true;
                this.ready.signalAll();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setException(Throwable exception) {
        this.lock.lock();
        try {
            if (!this.done) {
                this.exception = exception;
                this.done = true;
                this.ready.signalAll();
            }
        }
        finally {
            this.lock.unlock();
        }
    }
}

