/*
 * Decompiled with CFR 0.152.
 */
package com.dinstone.beanstalkc.internal.operation;

import com.dinstone.beanstalkc.internal.OperationFuture;
import com.dinstone.beanstalkc.internal.operation.AbstractOperation;
import java.nio.charset.Charset;
import org.apache.mina.core.buffer.IoBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KickOperation
extends AbstractOperation<Long> {
    private static final Logger LOG = LoggerFactory.getLogger(KickOperation.class);

    public KickOperation(long bound) {
        super(new OperationFuture());
        this.command = "kick " + bound;
    }

    @Override
    public boolean parseReply(Charset charset, IoBuffer in) {
        try {
            String line = in.getString(charset.newDecoder());
            LOG.debug("command is [{}], reply is [{}]", (Object)this.command, (Object)line);
            if (line.startsWith("KICKED")) {
                long id = Long.parseLong(line.replaceAll("[^0-9]", ""));
                this.future.setResult(id);
                return true;
            }
            this.exceptionHandler(line);
        }
        catch (Exception e) {
            this.future.setException(e);
        }
        return true;
    }
}

