/*
 * Decompiled with CFR 0.152.
 */
package com.dinstone.beanstalkc.internal.operation;

import com.dinstone.beanstalkc.Job;
import com.dinstone.beanstalkc.internal.OperationFuture;
import com.dinstone.beanstalkc.internal.operation.AbstractOperation;
import java.nio.charset.Charset;
import org.apache.mina.core.buffer.IoBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeekOperation
extends AbstractOperation<Job> {
    private static final Logger LOG = LoggerFactory.getLogger(PeekOperation.class);
    private Peeked peeked;

    public PeekOperation(long jobId) {
        super(new OperationFuture());
        this.command = "peek " + jobId;
    }

    public PeekOperation(Type type) {
        super(new OperationFuture());
        if (type == Type.ready) {
            this.command = "peek-ready";
        } else if (type == Type.delayed) {
            this.command = "peek-delayed";
        } else if (type == Type.buried) {
            this.command = "peek-buried";
        }
    }

    @Override
    public boolean parseReply(Charset charset, IoBuffer in) {
        if (this.peeked != null) {
            Job job = new Job();
            job.setId(this.peeked.id);
            byte[] data = new byte[this.peeked.length];
            in.get(data, 0, this.peeked.length);
            job.setData(data);
            this.future.setResult(job);
            return true;
        }
        try {
            String line = in.getString(charset.newDecoder());
            LOG.debug("command is [{}], reply is [{}]", (Object)this.command, (Object)line);
            if (line.startsWith("NOT_FOUND")) {
                this.future.setResult(null);
                return true;
            }
            if (line.startsWith("FOUND")) {
                this.peeked = new Peeked();
                String[] tmp = line.split("\\s+");
                this.peeked.id = Long.parseLong(tmp[1]);
                this.peeked.length = Integer.parseInt(tmp[2]);
                return false;
            }
            this.exceptionHandler(line);
        }
        catch (Exception e) {
            this.future.setException(e);
        }
        return true;
    }

    @Override
    public int expect() {
        if (this.peeked != null) {
            return this.peeked.length;
        }
        return 0;
    }

    private static class Peeked {
        long id;
        int length;

        private Peeked() {
        }
    }

    public static enum Type {
        ready,
        delayed,
        buried;

    }
}

